<?php
namespace Blue2\Scruffy;

use Blue2\Scruffy\Controllers\ProductController;

class Site extends \Blue2\Common\Site
{
    public function __construct()
    {
        parent::__construct();

        add_theme_support('woocommerce');
        add_theme_support('post-thumbnails');
        add_theme_support('woocommerce');
        add_action('after_setup_theme', [$this, 'registerMenus']);
        add_filter('excerpt_more', [$this, 'tidyExcerpt']);

        $this->registerShortCodes();
        $this->registerFilters();
        $this->registerActions();
        $this->setupControllers();
    }

    public function registerMenus()
    {
        register_nav_menus([
            'main_menu' => 'Main Menu',
            'footer_products_menu' => 'Footer Products Menu',
            'footer_services_menu' => 'Footer Services Menu',
            'footer_company_menu' => 'Footer Company Menu',
            'footer_customer_service_menu' => 'Footer Customer Service Menu',
            'footer_documentation_menu' => 'Footer Documentation Menu',
        ]);
    }

    public function tidyExcerpt()
    {
        return ' &hellip; <a href="' . get_permalink() . '">Continued</a>';
    }

    private function registerShortCodes()
    {
        // Empty
    }

    private function registerFilters(){
        add_filter('acf/fields/google_map/api', [$this, 'myAcfGoogleMapApi']);
        add_filter('wp_enqueue_scripts', [$this, 'enqueueScripts']);
    }

    private function registerActions() {
        add_action('init', [$this, 'registerPostTypes']);
        add_action('init', [$this, 'customOptionsPages']);
        add_action('init', [$this, 'customImageSizes']);
    }

    private function setupControllers(){
        new ProductController();
    }

    public function registerPostTypes()
    {

    }

    public function customImageSizes()
    {
        add_image_size('product-card-image', 0, 265, false);
    }

    public function enqueueScripts()
    {
        $layouts = get_post_meta(get_the_id(), 'flexible_sections', true);
        if (is_array($layouts) && in_array('contact_section', $layouts)) {
            wp_enqueue_script('google-maps', '//maps.googleapis.com/maps/api/js?key=AIzaSyCqF8Zo89zCj3kzStNPcfuqZBAnhW8Dmwo', ['jquery'], null, true);
        }
    }

    public function myAcfGoogleMapApi($api)
    {
        $api['key'] = 'AIzaSyCqF8Zo89zCj3kzStNPcfuqZBAnhW8Dmwo';
        return $api;
    }

    public function customOptionsPages()
    {
        if (function_exists('acf_add_options_page')) {
            acf_add_options_page([
                'title' => 'Product Settings',
                'parent' => 'edit.php?post_type=product',
                'capability' => 'edit_posts',
            ]);
        }
    }



}
