<?php

$title = get_field('title') ?: 'Hire';
$subtitle = get_field('subtitle');
$description = get_field('description');

$deliveryTitle = get_field('information_title');
$deliveryDesc = get_field('information_description');
$deliveryRows = get_field('information_rows');
$hireItems = get_field('hire_items');


?>

<div class="custom-hire-template">

    <div class="hero-section">
        <div class="hero-holder">
            <div class="top-hero-section" style="background-image:url('<?= get_the_post_thumbnail_url(); ?>')"></div>
            <div class="bottom-hero-section">
                <div class="container">
                    <div class="row">
                        <div class="col-lg-6 primary-col">
                            <div class="primary-holder">
                                <div class="top underlay-active">
                                    <h1><?= $title; ?></h1>
                                </div>
                                <div class="bottom">
                                    <?php if($subtitle) { ?><h2><?= $subtitle; ?></h2><?php } ?>
                                    <div class="description"><?= $description; ?></div>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-6 secondary-col d-flex align-items-center justify-content-center">
                            <?php
                            $ctaFile = get_field('hire_catalogue');
                            ?>
                            <div class="secondary-holder">
                                <?php if($ctaFile) {
                                    $ctaText = 'Download our Hire Catalogue:';
                                    $ctaButtonText = 'Download PDF'; ?>
                                    <div class="hero-cta-holder">
                                        <div class="text"><?= $ctaText; ?></div>
                                        <div class="cta"><a href="<?= $ctaFile['url']; ?>" target="_blank"><?= $ctaButtonText; ?></a></div>
                                    </div>
                                <?php } ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="hire-output">
        <div class="container">
            <div class="row">
                <?php if($hireItems) {

                    get_template_part('templates/sections/modals/hire-modal');

                    $companyLogoAlt = get_field('alternate_company_logo', 'option');
                    foreach ($hireItems as $item) {
                        $image = $item['hire_image']['url'] ?: $companyLogoAlt['url'];
                        $imageClass = $item['hire_image']['url'] ? 'featured-image' : 'default-image';
                        ?>
                        <div class="col-lg-6 col-xl-4 hire-col">
                            <div class="hire-item">
                                <a href="<?= get_permalink(); ?>" data-toggle="modal" data-target="#hireModal" data-title="<?= $item['hire_name']; ?>" data-per-day="<?= $item['per_day_price']; ?>" data-per-week="<?= $item['per_week_price']; ?>">
                                    <div class="image-holder <?= $imageClass; ?>"><img src="<?= $image; ?>" alt="<?= $item['hire_name']; ?>"></div>
                                    <h2 title="<?= $item['hire_name']; ?>"><?= $item['hire_name']; ?></h2>
                                    <div class="price">
                                        <ul>
                                            <?php if($item['per_day_price']) { ?><li>Per day <strong><?= get_woocommerce_currency_symbol() . $item['per_day_price']; ?></strong></li><?php } ?>
                                            <?php if($item['per_week_price']) { ?><li>Per Week <strong><?= get_woocommerce_currency_symbol() . $item['per_week_price']; ?></strong></li><?php } ?>
                                        </ul>
                                    </div>
                                    <span class="product-overlay">
                                        <div class="product-page-box">Enquire Now</div>
                                    </span>
                                </a>
                            </div>
                        </div>
                    <?php }
                } else { ?>
                    <div class="col-12">
                        <div class="no-hire-items"><?php the_field('no_hire_items_message'); ?></div>
                    </div>
                <?php } ?>
            </div>
        </div>
    </div>

    <div class="delivery-information">
        <div class="container">
            <h2><?= $deliveryTitle; ?></h2>
            <?php if($deliveryRows) { ?>
                <div class="delivery-rows">
                    <?php foreach($deliveryRows as $row) { ?>
                        <div class="delivery-row">
                            <div class="area"><?= $row['area']; ?></div>
                            <div class="distance"><?= $row['distance']; ?></div>
                            <div class="price"><?= $row['price']; ?></div>
                        </div>
                    <?php } ?>
                </div>
            <?php } ?>
            <?php if($deliveryDesc) { ?><div class="description"><?= $deliveryDesc ?></div><?php } ?>
        </div>
    </div>
</div>
