<?php
$brands = get_terms('brand', ['hide_empty' => false]);
$conditions = get_terms('condition', ['hide_empty' => false]);
?>
<div class="filter-bar category-filter-bar">
    <form class="filter-form">
        <div class="filter">
            <?php if(!is_tax('brand')) { ?>
                <div class="select-holder">
                    <select name="make">
                        <option value="">All Brands</option>
                        <?php foreach($brands as $brand) {
                            $selectedBrand = isset($_GET['make']) && $_GET['make'] == $brand->slug ? 'selected' : "";
                            ?>
                            <option value="<?= $brand->slug ?>" <?= $selectedBrand ?>><?= $brand->name; ?></option>
                        <?php } ?>
                    </select>
                    <div class="custom-select-arrow"><i class="fas fa-chevron-down"></i></div>
                </div>
            <?php }
            if(is_shop() || is_tax('brand')) {
                $types = get_terms('product_cat', ['hide_empty' => false]); ?>
                <div class="select-holder">
                    <select name="product-category">
                        <option value="">Type</option>
                        <?php foreach($types as $type) {
                            $selectedType = isset($_GET['product-category']) && $_GET['product-category'] == $type->slug ? 'selected' : "";
                            ?>
                            <option value="<?= $type->slug ?>" <?= $selectedType; ?>><?= $type->name; ?></option>
                        <?php } ?>
                    </select>
                    <div class="custom-select-arrow"><i class="fas fa-chevron-down"></i></div>
                </div>
            <?php } ?>
            <div class="select-holder">
                <select name="condition">
                    <option value="">All Conditions</option>
                    <?php foreach($conditions as $condition) {
                        $selectedCondition = isset($_GET['condition']) && $_GET['condition'] == $condition->slug ? 'selected' : "";
                        ?>
                        <option value="<?= $condition->slug ?>" <?= $selectedCondition; ?>><?= $condition->name; ?></option>
                    <?php } ?>
                </select>
                <div class="custom-select-arrow"><i class="fas fa-chevron-down"></i></div>
            </div>
            <div class="select-holder">
                <select name="price-range">
                    <option value="">Price Range</option>
                    <option value="0-250" <?php if(isset($_GET['price-range']) && $_GET['price-range'] == "0-250") { echo 'selected'; } ?>>£0 - £250</option>
                    <option value="250-500" <?php if(isset($_GET['price-range']) && $_GET['price-range'] == "250-500") { echo 'selected'; } ?>>£250 - £500</option>
                    <option value="500-1000" <?php if(isset($_GET['price-range']) && $_GET['price-range'] == "500-1000") { echo 'selected'; } ?>>£500 - £1000</option>
                    <option value="1000-1500" <?php if(isset($_GET['price-range']) && $_GET['price-range'] == "1000-1500") { echo 'selected'; } ?>>£1000 - £1500</option>
                    <option value="1500-2000" <?php if(isset($_GET['price-range']) && $_GET['price-range'] == "1500-2000") { echo 'selected'; } ?>>£1500 - £2000</option>
                    <option value="2000" <?php if(isset($_GET['price-range']) && $_GET['price-range'] == "2000") { echo 'selected'; } ?>>£2000+</option>
                </select>
                <div class="custom-select-arrow"><i class="fas fa-chevron-down"></i></div>
            </div>
        </div>
        <div class="sort">
            <?php
            $lowHighActive = isset($_GET['sort-by']) && $_GET['sort-by'] == 'low-to-high' ? 'selected' : "";
            $HighLowActive = isset($_GET['sort-by']) && $_GET['sort-by'] == 'high-to-low' ? 'selected' : "";
            ?>
            <div class="select-holder">
                <select name="sort-by">
                    <option value="">Sort By</option>
                    <option value="low-to-high" <?= $lowHighActive; ?>>Price (Low to high)</option>
                    <option value="high-to-low" <?= $HighLowActive; ?>>Price (High to Low)</option>
                </select>
                <div class="custom-select-arrow"><i class="fas fa-chevron-down"></i></div>
            </div>
        </div>
    </form>
</div>
