<?php
$brands = get_terms('brand', ['hide_empty' => false]);
$conditions = get_terms('condition', ['hide_empty' => false]);
?>
<div class="filter-bar category-filter-bar">
    <div class="filter">
        <form class="filter-form">
            <div class="select-holder">
                <select name="brand">
                    <option value="">All Brands</option>
                    <?php foreach($brands as $brand) {
                        $selectedBrand = isset($_GET['brand']) && $_GET['brand'] == $brand->slug ? 'selected' : "";
                        ?>
                        <option value="<?= $brand->slug ?>" <?= $selectedBrand ?>><?= $brand->name; ?></option>
                    <?php } ?>
                </select>
                <div class="custom-select-arrow"><i class="fas fa-chevron-down"></i></div>
            </div>

            <?php if(is_shop()) {
                $uncategorised = get_term_by('slug', 'uncategorized', 'product_cat');
                $types = get_terms('product_cat', ['hide_empty' => false, 'exclude' => $uncategorised->term_id]); ?>
                <div class="select-holder">
                    <select name="product-category">
                        <option value="">Type</option>
                        <?php foreach($types as $type) {
                            $selectedType = isset($_GET['product-category']) && $_GET['product-category'] == $type->slug ? 'selected' : "";
                            ?>
                            <option value="<?= $type->slug ?>" <?= $selectedType; ?>><?= $type->name; ?></option>
                        <?php } ?>
                    </select>
                    <div class="custom-select-arrow"><i class="fas fa-chevron-down"></i></div>
                </div>
            <?php } ?>

            <div class="select-holder">
                <select name="condition">
                    <option value="">All Conditions</option>
                    <?php foreach($conditions as $condition) {
                        $selectedCondition = isset($_GET['condition']) && $_GET['condition'] == $condition->slug ? 'selected' : "";
                        ?>
                        <option value="<?= $condition->slug ?>" <?= $selectedCondition; ?>><?= $condition->name; ?></option>
                    <?php } ?>
                </select>
                <div class="custom-select-arrow"><i class="fas fa-chevron-down"></i></div>
            </div>
            <div class="select-holder">
                <select name="price-range">
                    <option value="">Price Range</option>
                    <!--  todo - populate price range when we have the brackets -->
                </select>
                <div class="custom-select-arrow"><i class="fas fa-chevron-down"></i></div>
            </div>
        </form>
    </div>
    <div class="sort">
        <form class="sort-form">
            <div class="select-holder">
                <select name="sort-by">
                    <option value="">Sort By</option>
                    <!--  todo - populate sorts -->
                </select>
                <div class="custom-select-arrow"><i class="fas fa-chevron-down"></i></div>
            </div>
        </form>
    </div>
</div>
