<?php
$title = get_sub_field('information_title');
$description = get_sub_field('information_description');
$cta = get_sub_field('information_cta');
$image = get_sub_field('information_background_image');

$telephone = get_field('contact_phone_number', 'option');
$email = get_field('contact_email_address', 'option');
$fax = get_field('contact_fax_number', 'option');

$informationBlockPosition = get_sub_field('information_block_position');
$primaryColOrder = $informationBlockPosition == 'right' ? "order-2 order-lg-1" : "order-2 order-lg-2";
$secondaryColOrder = $informationBlockPosition == 'right' ? "order-1 order-lg-2" : "order-1 order-lg-1";
?>

<div class="flexible-section information-section">
    <div class="top-image">
        <img src="<?= $image['url']; ?>">
    </div>
    <div class="container">
        <div class="row">
            <div class="col-lg-6 <?= $primaryColOrder; ?> primary-col d-flex align-items-center">
                <div class="contact-block">
                    <div class="title">Questions? <span>We have answers...</span></div>
                    <div class="contact-hold">
                        <ul class="contact-items">
                            <?php if($telephone) { ?><li><i class="fas fa-phone"></i> <a href="tel:<?= $telephone; ?>"><?= $telephone; ?></a></li><?php } ?>
                            <?php if($fax) { ?><li><i class="fal fa-fax"></i> <a href="tel:<?= $fax; ?>"><?= $fax; ?></a></li><?php } ?>
                            <?php if($email) { ?><li class="email"><i class="far fa-envelope"></i> <a href="mailto:<?= $email; ?>"><?= $email; ?></a></li><?php } ?>
                        </ul>
                        <?php if (have_rows('social_media_channels', 'option')) { ?>
                            <div class="social-holder">
                                <h3>Follow us:</h3>
                                <ul class="footer-socials">
                                    <?php while (have_rows('social_media_channels', 'option')) {
                                        the_row(); ?>
                                        <li>
                                            <a href="<?php the_sub_field('full_url'); ?>" target="_blank" rel="noopener">
                                                <span class="fa-stack fa-2x">
                                                  <i class="fas fa-circle fa-stack-2x"></i>
                                                  <i class="<?php the_sub_field('fa5_icon_class'); ?> fa-stack-1x fa-inverse"></i>
                                                </span>
                                            </a>
                                        </li>
                                    <?php } ?>
                                </ul>
                            </div>
                        <?php } ?>
                    </div>
                </div>
            </div>
            <div class="col-lg-6 <?= $secondaryColOrder; ?> secondary-col">
                <div class="information-block">
                    <?php if($cta) { ?><a href="<?= $cta['url']; ?>"><?php } ?>
                        <h2 class="title"><?= $title ?></h2>
                        <div class="content"><?= $description; ?></div>
                    <?php if($cta) { ?></a><?php } ?>
                </div>
            </div>
        </div>
    </div>
</div>
