<?php
/**
 * The template for displaying product content within loops
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.6.0
 */

defined( 'ABSPATH' ) || exit;

global $product;

// Ensure visibility.
if ( empty( $product ) || ! $product->is_visible() ) {
    return;
}
$companyLogoAlt = get_field('alternate_company_logo', 'option');
$image = get_the_post_thumbnail_url(get_the_id(), 'product-card-image') ?: $companyLogoAlt['url'];
$imageClass = get_the_post_thumbnail_url(get_the_id()) ? 'featured-image' : 'default-image';
$saleClass = $product->get_sale_price() ? 'sale-active' : 'sale-inactive';

$displayPrice = wc_get_price_to_display( $product, ['price' => $product->get_regular_price()]);
$salePrice = wc_get_price_to_display( $product, ['price' => $product->get_sale_price()]);

?>
<div <?php wc_product_class( 'product-col col-md-6 col-xl-4', $product ); ?>>
    <div class="product-item">
        <a href="<?= get_permalink(); ?>">
            <div class="image-holder <?= $imageClass; ?>"><img src="<?= $image; ?>" alt="<?php the_title(); ?>"></div>
            <h2 title="<?= $product->get_name(); ?>"><?= $product->get_name(); ?></h2>

            <div class="bottom-holder">
                <div class="price-holder <?= $saleClass; ?>">
                    <div class="price rrp <?= $saleClass; ?>"><span class="amount"><?= get_woocommerce_currency_symbol() . number_format($displayPrice, 2) . '</span> <span class="price-suffix">RRP</span>'; ?></div>
                    <?php if($product->get_sale_price()) { ?><div class="price sale"><?= get_woocommerce_currency_symbol() . number_format($salePrice, 2) . ' <span class="price-suffix">Our Price</span>'; ?></div><?php } ?>
                </div>
                <?php if (!$product->is_in_stock()) { ?>
                    <span class="stock-message">Out of stock</span>
                <?php } ?>
            </div>
            <span class="product-overlay">
                  <div class="product-page-box">Go to product page</div>
            </span>
        </a>
    </div>
</div>
