$(document).ready(() => {
    $('.sync_button').click(function(e) {
        e.preventDefault();
        // eslint-disable-next-line no-undef
        Swal.fire({
            title: '<strong>Syncing <u>IBCOS</u></strong>',
            html: '</br><i class="fa fa-spinner fa-pulse fa-3x fa-fw"></i> <br><br>Please wait a moment while the information is being downloaded and updated.' +
                '<span class="sr-only">Loading...</span>',
            showCloseButton: false,
            showCancelButton: false,
            showConfirmButton: false,
            allowOutsideClick: false,

        });
        const nonce = $(this).attr('data-nonce');
        $.ajax({
            type: 'get',
            // eslint-disable-next-line no-undef
            url: myAjax.ajaxurl,
            data: {
                action: 'sync_files',
                nonce
            },
            success(response) {
                const data = response.split('-');
                // eslint-disable-next-line no-undef
                Swal.fire({
                    icon: 'success',
                    title: 'Sync done!',
                    text: `A total of ${data[2].substring(0,data[2].length - 1)} products where found. ${data[1]} new products were added to the system.`,
                });
                console.log(response);
            },
            statusCode: {
                500(response) {
                    // eslint-disable-next-line no-undef
                    Swal.fire({
                        icon: 'error',
                        title: 'Oops...',
                        text: 'Something went wrong!',
                    });
                    console.log(response);
                }
            }
        });
    });
});
