<?php

namespace Blue2\Scruffy\Controllers;

class ProductController
{
    public function __construct()
    {
        $this->registerActions();
        $this->registerFilters();
    }

    private function registerActions()
    {
        add_action('init', [$this, 'registerTaxonomies']);
        add_action('pre_get_posts', [$this, 'customProductFilter'] );
        add_action('pre_get_posts', [$this, 'setShopProductsPerPage'] );
        add_action('init', [$this, 'woocommerceHookAdjustments']);
    }

    private function registerFilters()
    {
        add_filter('manage_edit-product_columns', [$this, 'changeProductAdminColumns'],15 );
        add_filter('woocommerce_pagination_args', [$this, 'customWoocommercePagination']);
    }

    public function registerTaxonomies(){
        $productCondition = new \Blue2\Common\Taxonomy("condition", "Condition", "Conditions", "product", [], $args = [
            'show_ui' => true,
            'query_var' => true,
            'show_admin_column' => true,
        ]);
        $productBrand = new \Blue2\Common\Taxonomy("brand", "Brand", "Brands", "product", [], $args = [
            'show_ui' => true,
            'query_var' => true,
            'show_admin_column' => true,
        ]);
    }

    function changeProductAdminColumns($columns){
        unset( $columns['product_tag'] );
        unset( $columns['featured'] );
        return $columns;
    }

    public function setShopProductsPerPage($query){
        if (!is_admin() && is_shop() && $query->is_main_query()) {
            $query->set( 'posts_per_page', 24 );
        }
    }

    public function customWoocommercePagination($args) {
        $args['prev_text'] = 'Previous';
        $args['next_text'] = 'Next';
        $args['mid_size'] = 0;
        $args['end_size'] = 1;
        $args['show_all'] = false;
        return $args;
    }

    public function customProductFilter($query)
    {
        if (!is_admin() && ($query->is_tax('product_cat') || is_shop() )) {
            $taxQuery = ['relation' => 'AND'];
            if(isset($_GET['brand']) && $_GET['brand'] !== '') {
                $brand = $_GET['brand'];
                $taxQuery[] = [
                    'taxonomy' => 'brand',
                    'terms' => $brand,
                    'field' => 'slug',
                    'operator' => 'IN'
                ];
                $query->set( 'tax_query', $taxQuery );
            }

            if(isset($_GET['condition']) && $_GET['condition'] !== '') {
                $condition = $_GET['condition'];
                $taxQuery[] = [
                    'taxonomy' => 'condition',
                    'terms' => $condition,
                    'field' => 'slug',
                    'operator' => 'IN'
                ];
                $query->set( 'tax_query', $taxQuery );
            }

            if(isset($_GET['product-category']) && $_GET['product-category'] !== '') {
                $type = $_GET['product-category'];
                $taxQuery[] = [
                    'taxonomy' => 'product_cat',
                    'terms' => $type,
                    'field' => 'slug',
                    'operator' => 'IN'
                ];
                $query->set( 'tax_query', $taxQuery );
            }

            //todo - add price range check when we have the price brackets
        }
    }

    public function woocommerceHookAdjustments() {
        remove_action('woocommerce_before_shop_loop', 'woocommerce_result_count', 20);
        remove_action('woocommerce_before_shop_loop', 'woocommerce_catalog_ordering', 30);
    }

    public static function dynamicArchiveTitle() {
        $dynamicTitle = [];
        if(isset($_GET['brand']) && $_GET['brand'] !== '') {
            $brand = get_term_by('slug', $_GET['brand'], 'brand');
            $dynamicTitle[] = $brand->name;
        }
        if(isset($_GET['product-category']) && $_GET['product-category'] !== ''){
            $productCategory = get_term_by('slug', $_GET['product-category'], 'product_cat');
            $dynamicTitle[] = $productCategory->name;
        }
        if(isset($_GET['condition']) && $_GET['condition'] !== '') {
            $condition = get_term_by('slug', $_GET['condition'], 'condition');
            $dynamicTitle[] = $condition->name;
        }
        $title = implode(' - ', $dynamicTitle) ?: 'Shop';
        return $title;
    }

}
