$(document).ready(function () {
    $(".sync_button").click(function (e) {
        e.preventDefault();
        Swal.fire({
            title: '<strong>Syncing <u>IBCOS</u></strong>',
            //text: 'Please wait a moment while the information is being downloaded and updated.',
            html: '</br><i class="fa fa-spinner fa-pulse fa-3x fa-fw"></i> <br><br>Please wait a moment while the information is being downloaded and updated.' +
                '<span class="sr-only">Loading...</span>',
            showCloseButton: false,
            showCancelButton: false,
            showConfirmButton: false,
            allowOutsideClick: false,

        });
        nonce = $(this).attr("data-nonce");
        $.ajax({
            type: "get",
            url: myAjax.ajaxurl,
            data: {
                action: 'sync_files',
                nonce: nonce
            },
            success: function (response) {
                var data = response.split('-');
                Swal.fire({
                    icon: 'success',
                    title: 'Sync done!',
                    text: 'A total of ' + data[2].substring(0,data[2].length-1) + ' products where found. ' + data[1] + ' new products were added to the system.',
                });
                console.log(response);
            },
            statusCode: {
                500: function (response) {
                    Swal.fire({
                        icon: 'error',
                        title: 'Oops...',
                        text: 'Something went wrong!',
                    });
                    console.log(response);
                }
            }
        });
    });
});