<?php
$companyLogo = get_field('company_logo', 'option');
?>

<nav class="header-nav">
    <div class="left-section">
        <a class="navbar-brand" href="<?= esc_url(home_url('/')); ?>">
            <img src="<?= $companyLogo['url']; ?>" alt="<?php bloginfo('name'); ?>" />
        </a>
    </div>

    <div class="middle-section">
        <div class="collapse navbar-collapse" id="navbarSupportedContent">
            <?php
            if (has_nav_menu('main_menu')) {
                wp_nav_menu(['theme_location' => 'main_menu', 'menu_class' => 'navigation']);
            }
            ?>
        </div>
    </div>


    <div class="right-section">
        <div class="cart right-item">
            <i class="fas fa-shopping-cart"></i>
        </div>
        <div class="account right-item">
            <i class="fas fa-user"></i>
        </div>
        <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
            <span class="navbar-toggler-icon"></span>
        </button>
        <div class="search right-item">
            <i class="fal fa-search"></i>
            <form role="search" method="get" class="custom-search-form" action="/">
                <div class="search-holder">
                    <input type="search" class="search-field" placeholder="Search..." value="" name="s" />
                </div>
            </form>

        </div>
    </div>

</nav>
