<?php
$overlays = get_sub_field('overlay_panels');
$heroType = get_sub_field('hero_type');
$heroRightType = get_sub_field('hero_right_type');
$heroImage = get_sub_field('image');
$heroVideo = get_sub_field('video');
$cta = get_sub_field('cta');
$title = get_sub_field('main_title');
$subtitle = get_sub_field('subtitle');
$underlay = get_sub_field('use_green_underlay_on_title') ? 'underlay-active' : 'underlay-inactive';
?>
<!-- todo - integrate animated menu option overlay -->
<div class="flexible-section hero-section <?= 'type-' . $heroType; ?>">

    <div class="hero-holder">
        <div class="top-hero-section" style="background-image:url('<?= $heroImage['url']; ?>')">
            <?php if($heroType == 'video' && $heroVideo) { ?>
                <video muted autoplay>
                    <source src="<?= $heroVideo['url']; ?>" type="video/mp4">
                </video>
            <?php } ?>
        </div>
        <?php if($overlays) { ?>
            <div class="overlays">
                <?php foreach($overlays as $overlay) { ?>
                    <div class="overlay-section">
                        <a href="<?= $overlay['cta']['url']; ?>">
                            <div class="top"><h3><?= $overlay['title']; ?></h3><i class="far fa-arrow-right"></i></div>
                            <span class="description"><?= $overlay['description']; ?></span>
                        </a>
                    </div>
                <?php } ?>
            </div>
        <?php } ?>
    </div>

    <div class="bottom-hero-section">
        <div class="container">
            <div class="row">
                <div class="col-lg-6 primary-col">
                    <div class="primary-holder">
                        <div class="top <?= $underlay; ?>">
                            <?php if($heroType == 'video' && $heroVideo) { ?>
                                <div class="play-video"><i class="fas fa-play-circle"></i> Watch the video</div>
                            <?php }
                            if($title) { ?>
                                <h1><?= $title; ?></h1>
                            <?php } ?>
                        </div>
                        <div class="bottom">
                            <?php if($subtitle) { ?><h2><?= $subtitle; ?></h2><?php } ?>
                            <div class="description"><?php the_sub_field('description'); ?></div>
                            <?php if($cta) { ?><a href="<?= $cta['url']; ?>"><?= $cta['title']; ?> <i class="far fa-arrow-right"></i></a><?php } ?>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6 secondary-col d-flex align-items-center justify-content-center">
                    <div class="secondary-holder">
                        <?php if($heroRightType == 'social-media' && have_rows('social_media_channels', 'option')) { ?>
                            <div class="hero-social-holder">
                                <h3>Follow us:</h3>
                                <ul class="hero-socials">
                                    <?php while (have_rows('social_media_channels', 'option')) {
                                        the_row(); ?>
                                        <li>
                                            <a href="<?php the_sub_field('full_url'); ?>" target="_blank" rel="noopener">
                                            <span class="fa-stack fa-2x">
                                              <i class="fas fa-circle fa-stack-2x"></i>
                                              <i class="<?php the_sub_field('fa5_icon_class'); ?> fa-stack-1x fa-inverse"></i>
                                            </span>
                                            </a>
                                        </li>
                                    <?php } ?>
                                </ul>
                            </div>
                        <?php } elseif($heroRightType == 'cta') {
                            $ctaText = get_sub_field('hero_right_cta_text');
                            $ctaType = get_sub_field('hero_right_cta_type');
                            $ctaFile = get_sub_field('hero_right_cta_file');
                            $ctaLink = get_sub_field('hero_right_cta_link');
                            $ctaButtonURL = $ctaType == 'file' ? $ctaFile['url'] : $ctaLink['url'];
                            $ctaButtonText = $ctaType == 'file' ? 'Download File' : $ctaLink['title'];
                            $target = $ctaType == 'file' ? "_blank" : "_self";
                            ?>
                            <div class="hero-cta-holder">
                                <div class="text"><?= $ctaText; ?></div>
                                <div class="cta"><a href="<?= $ctaButtonURL; ?>" target="<?= $target; ?>"><?= $ctaButtonText; ?></a></div>
                            </div>
                        <?php } ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
