<?php

namespace Blue2\Scruffy\Controllers;

class ProductController
{
    public function __construct()
    {
        $this->registerActions();
        $this->registerFilters();
    }

    private function registerActions()
    {
        add_action('init', [$this, 'registerTaxonomies']);
        add_action('pre_get_posts', [$this, 'customProductFilter']);
        add_action('pre_get_posts', [$this, 'setShopProductsPerPage']);
        add_action('init', [$this, 'woocommerceHookAdjustments']);
        add_action('init', [$this, 'script_enqueuer']);
        add_action('wp_ajax_sync_files', [$this, 'ibcosSync']);
        add_action('admin_menu', [$this, 'syncFiles']);

    }

    public function syncFiles2()
    {
        echo '<h1>IBCOS Sync.</h1>';
        echo '<h3>In this page, you can update Products catalogue importing new items from IBCOS last dump.</h3>';
        echo 'The operation may take up to a minute to complete. While updating, please stay in the page and don\'t refresh.<br><br>';

        $nonce = wp_create_nonce("sync_files_nonce");
        $link = admin_url('admin-ajax.php?action=sync_files&nonce=' . $nonce);
        echo '<button type="button" class="sync_button page-title-action" data-nonce="' . $nonce . '" href="' . $link . '">Start Sync</button>';
    }

    private function registerFilters()
    {
        add_filter('manage_edit-product_columns', [$this, 'changeProductAdminColumns'], 15);
        add_filter('woocommerce_pagination_args', [$this, 'customWoocommercePagination']);
        add_filter('woocommerce_product_single_add_to_cart_text', [$this, 'customAddToCartText']);
        add_filter('woocommerce_account_menu_items', [$this, 'updateAccountMenu'], 999);
        add_filter('woocommerce_account_menu_items', [$this, 'updateAccountMenu'], 999);
        add_filter('woocommerce_sale_flash', [$this, 'removeSaleBadge']);
        add_filter('woocommerce_get_stock_html', [$this, 'hideInStockMessage'], 10, 3);
    }

    public function registerTaxonomies()
    {
        $productCondition = new \Blue2\Common\Taxonomy("condition", "Condition", "Conditions", "product", [], $args = [
            'show_ui' => true,
            'query_var' => true,
            'show_admin_column' => true,
        ]);
        $productBrand = new \Blue2\Common\Taxonomy("brand", "Brand", "Brands", "product", [], $args = [
            'show_ui' => true,
            'query_var' => true,
            'show_admin_column' => true,
        ]);

        $productModel = new \Blue2\Common\Taxonomy("model", "Model", "Models", "product", [], $args = [
            'show_ui' => false,
            'query_var' => true,
            'show_admin_column' => false,
        ]);
    }


    function customAddToCartText()
    {
        return __('Buy', 'woocommerce');
    }

    public function changeProductAdminColumns($columns)
    {
        unset($columns['product_tag']);
        unset($columns['featured']);
        return $columns;
    }

    public function setShopProductsPerPage($query)
    {
        if (!is_admin() && is_shop() && $query->is_main_query()) {
            $query->set('posts_per_page', 24);
        }
    }

    public function customWoocommercePagination($args)
    {
        $args['prev_text'] = 'Previous';
        $args['next_text'] = 'Next';
        $args['mid_size'] = 0;
        $args['end_size'] = 1;
        $args['show_all'] = false;
        return $args;
    }

    public function customProductFilter($query)
    {
        if (!is_admin() && ($query->is_tax('product_cat') || $query->is_tax('brand')) || (is_shop() && $query->is_main_query())) {
            $taxQuery = ['relation' => 'AND'];
            $metaQuery = [];
            if (isset($_GET['make']) && $_GET['make'] !== '') {
                $brand = $_GET['make'];
                $taxQuery[] = [
                    'taxonomy' => 'brand',
                    'terms' => $brand,
                    'field' => 'slug',
                    'operator' => 'IN'
                ];
                $query->set('tax_query', $taxQuery);
            }

            if (isset($_GET['condition']) && $_GET['condition'] !== '') {
                $condition = $_GET['condition'];
                $taxQuery[] = [
                    'taxonomy' => 'condition',
                    'terms' => $condition,
                    'field' => 'slug',
                    'operator' => 'IN'
                ];
                $query->set('tax_query', $taxQuery);
            }

            if (isset($_GET['product-category']) && $_GET['product-category'] !== '') {
                $type = $_GET['product-category'];
                $taxQuery[] = [
                    'taxonomy' => 'product_cat',
                    'terms' => $type,
                    'field' => 'slug',
                    'operator' => 'IN'
                ];
                $query->set('tax_query', $taxQuery);
            }

            if (isset($_GET['price-range']) && $_GET['price-range'] !== '') {
                $range = $_GET['price-range'];

                switch($range) {
                    case "0-250":
                        $bracket = ['0', '250'];
                        break;
                    case "250-500":
                        $bracket = ['250', '500'];
                        break;
                    case "500-1000":
                        $bracket = ['500', '1000'];
                        break;
                    case "1001-1500":
                        $bracket = ['1000', '1500'];
                        break;
                    case "1500-2000":
                        $bracket = ['1500', '2000'];
                        break;
                    case "2000":
                        $bracket = ['2000', '10000000'];
                        break;
                }

                $metaQuery[] = [
                    'key' => '_price',
                    'value' => $bracket,
                    'compare' => 'between',
                    'type'    => 'numeric',
                ];
                $query->set('meta_query', $metaQuery);
            }

            if (isset($_GET['sort-by']) && $_GET['sort-by'] !== '') {
                $sortType = $_GET['sort-by'];
                if ($sortType == 'low-to-high') {
                    $query->set('orderby', 'meta_value_num');
                    $query->set('meta_key', '_price');
                    $query->set('order', 'ASC');
                } else if ($sortType == 'high-to-low') {
                    $query->set('orderby', 'meta_value_num');
                    $query->set('meta_key', '_price');
                    $query->set('order', 'DESC');
                }
            }
        }
    }

    public function woocommerceHookAdjustments()
    {
        remove_action('woocommerce_before_shop_loop', 'woocommerce_result_count', 20);
        remove_action('woocommerce_before_shop_loop', 'woocommerce_catalog_ordering', 30);

        remove_action('woocommerce_sidebar', 'woocommerce_get_sidebar', 10);

        remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_rating', 10);
        remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_price', 10);
        remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_meta', 40);
        remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_sharing', 50);

        add_action('woocommerce_single_product_summary', [$this, 'customProductStats'], 25);
        add_action('woocommerce_single_product_summary', [$this, 'customPrice'], 25);
        add_action('woocommerce_single_product_summary', [$this, 'customEnquirySection'], 35);


        remove_action('woocommerce_after_single_product_summary', 'woocommerce_output_product_data_tabs', 10);
        remove_action('woocommerce_after_single_product_summary', 'woocommerce_upsell_display', 15);

        remove_action('woocommerce_before_main_content', 'woocommerce_breadcrumb', 20);
    }

    public static function dynamicArchiveTitle()
    {
        $dynamicTitle = [];
        if (isset($_GET['make']) && $_GET['make'] !== '') {
            $brand = get_term_by('slug', $_GET['make'], 'brand');
            $dynamicTitle[] = $brand->name;
        }
        if (isset($_GET['product-category']) && $_GET['product-category'] !== '') {
            $productCategory = get_term_by('slug', $_GET['product-category'], 'product_cat');
            $dynamicTitle[] = $productCategory->name;
        }
        if (isset($_GET['condition']) && $_GET['condition'] !== '') {
            $condition = get_term_by('slug', $_GET['condition'], 'condition');
            $dynamicTitle[] = $condition->name;
        }
        $title = implode(' - ', $dynamicTitle) ?: 'Products';
        return $title;
    }

    public function customPrice()
    {
        global $product;
        $saleClass = $product->get_sale_price() ? 'sale-active' : 'sale-inactive'; ?>
        <div class="price">
            <div class="inner-price rrp <?= $saleClass; ?>"><span
                        class="amount"><?= get_woocommerce_currency_symbol() . $product->get_regular_price() . '</span> <span class="price-suffix">RRP</span>'; ?>
            </div>
            <?php if ($product->get_sale_price()) { ?>
                <div class="inner-price sale"><?= get_woocommerce_currency_symbol() . $product->get_sale_price() . ' <span class="price-suffix">Our Price</span>'; ?></div><?php } ?>
        </div>
    <?php }

    public function customProductStats()
    {
        $stats = get_field('product_stats');
        if ($stats) { ?>
            <div class="product-stat-holder">
                <ul>
                    <?php foreach ($stats as $stat) { ?>
                        <li>
                            <?php if ($stat['font_awesome_icon']) { ?><span class="icon"><i
                                        class="<?= $stat['font_awesome_icon'] ?>"></i></span><?php } ?>
                            <span class="label"><?= $stat['label'] ?></span>
                            <span class="value"><?= $stat['value'] ?></span>
                        </li>
                    <?php } ?>
                </ul>
            </div>
        <?php }
    }

    public function customEnquirySection()
    {
        $perDayPrice = get_field('per_day_price');
        $perWeekPrice = get_field('per_week_price');
        if ($perDayPrice || $perWeekPrice) { ?>
            <div class="product-enquiry-holder">
                <div class="enquiry-prices">
                    <p>This product is also available for hire.</p>
                    <ul>
                        <?php if ($perDayPrice) { ?>
                            <li>Per day <strong><?= get_woocommerce_currency_symbol() . $perDayPrice; ?></strong>
                            </li><?php } ?>
                        <?php if ($perWeekPrice) { ?>
                            <li>Per Week <strong><?= get_woocommerce_currency_symbol() . $perWeekPrice; ?></strong>
                            </li><?php } ?>
                    </ul>
                </div>
                <a href="/enquiry/?enquiry=<?= get_the_title(); ?>" class="enquiry-button">Make an enquiry</a>
            </div>
        <?php }
    }

    public function updateAccountMenu($items)
    {
        unset($items['downloads']);
        return $items;
    }

    public function removeSaleBadge()
    {
        return false;
    }

    public function hideInStockMessage($html, $product)
    {
        $availability = $product->get_availability();
        if (isset($availability['class']) && 'in-stock' === $availability['class']) {
            return '';
        }
        return $html;
    }

    function script_enqueuer()
    {
        // Register the JS file with a unique handle, file location, and an array of dependencies
        if (is_admin('ibcos-sync')) {
            wp_register_script("liker_script", get_bloginfo('template_url') . '/assets/scripts/ibcos.js');
            wp_register_script("jquery3", 'https://code.jquery.com/jquery-3.5.1.min.js');
            wp_register_script("swal2", 'https://cdn.jsdelivr.net/npm/sweetalert2@10');

            wp_register_style("font-awesome", 'https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.1/css/all.min.css');
            wp_localize_script('liker_script', 'myAjax', array('ajaxurl' => admin_url('admin-ajax.php')));

            // enqueue jQuery library and the script you registered above
            wp_enqueue_script('jquery3');
            wp_enqueue_script('swal2');
            wp_enqueue_script('liker_script');

            wp_enqueue_style('font-awesome');
        }
    }

    public function syncFiles()
    {
        add_submenu_page(
            'edit.php?post_type=product',
            'IBCOS Sync', //page title
            'IBCOS Sync', //menu title
            'edit_themes', //capability,
            'ibcos-sync',//menu slug
            [$this, 'syncFiles2']//callback function
        );
    }

    public static function ibcosSync()
    {
        $new_items = 0;
        $old_items = 0;


        $args = array('limit' => -1);
        $products = wc_get_products($args);
        $out_of_stock_staus = 'outofstock';

        foreach ($products as $prod) {
            update_post_meta($prod->id, '_stock', 0);
            update_post_meta($prod->id, '_stock_status', wc_clean($out_of_stock_staus));
            wp_set_post_terms($prod->id, 'outofstock', 'product_visibility', true);
        }

        $ftp_server = "ftp.blue2.co.uk";
        $ftp_username = 'gammies';
        $ftp_userpass = 'TyoR04aj*f2Pl%Hx';

        $ftp_conn = ftp_connect($ftp_server) or die("Could not connect to $ftp_server");
        $login = ftp_login($ftp_conn, $ftp_username, $ftp_userpass);

        $h = fopen('php://temp', 'r+');
        ftp_fget($ftp_conn, $h, 'whgsend.xml');
        $fstats = fstat($h);
        fseek($h, 0);
        $contents = fread($h, $fstats['size']);

        $xml = simplexml_load_string($contents);
        $serials = [];
        foreach ($xml as $key => $node) {
            $query_args = array('tax_query' => array(
                array(
                    'taxonomy' => 'model',
                    'field' => 'name',
                    'terms' => $node->vmcode->__toString(),
                )));

            $r = new \WP_Query($query_args);

            if (!$r->have_posts()) {
                if (!in_array($node->vmcode->__toString(), $serials)) {
                    $serials[] = $node->vmcode->__toString();

                    $args = array(
                        'post_author' => 1,
                        'post_content' => '',
                        'post_status' => "draft", // (Draft | Pending | Publish)
                        'post_title' => $node->pre_desc->__toString() . ' ' . $node->vmcode->__toString(),
                        'post_parent' => '',
                        'post_type' => "product"
                    );


                    // Create a simple WooCommerce product
                    $post_id = wp_insert_post($args);

                    // Setting the product type
                    wp_set_object_terms($post_id, 'simple', 'product_type');
                    wp_set_object_terms($post_id, strtoupper($node->pre_desc->__toString()), 'brand');
                    wp_set_object_terms($post_id, $node->vmcode->__toString(), 'model');
                    // CONDITION OF PRODUCT LINE 158 wp_set_object_terms( $post_id, $node->pre_desc->__toString().' '.$node->vmcode->__toString(), 'ibcos_name' );

                    // Setting the product price
                    update_post_meta($post_id, '_price', floatval($node->vm_model_rrp));
                    update_post_meta($post_id, '_regular_price', floatval($node->vm_model_rrp));

                    if ($node->pictures->count() > 0) {
                        foreach ($node->pictures->picture as $pic) {
                            $upload_dir = wp_upload_dir();
                            $filename = basename($pic->__toString());

                            if (wp_mkdir_p($upload_dir['path'])) {
                                $filedir = $upload_dir['path'] . '/' . $filename;
                            } else {
                                $filedir = $upload_dir['basedir'] . '/' . $filename;
                            }

                            $file = fopen($filedir, 'w+');
                            ftp_fget($ftp_conn, $file, $pic->__toString());
                            fclose($file);

                            $image_data = $file;
                            file_put_contents($file, $image_data);
                            $wp_filetype = wp_check_filetype($filename, null);
                            $attachment = array(
                                'post_mime_type' => $wp_filetype['type'],
                                'post_title' => sanitize_file_name($filename),
                                'post_content' => '',
                                'post_status' => 'inherit'
                            );

                            $attach_id = wp_insert_attachment($attachment, $file);
                            $attach_data = wp_generate_attachment_metadata($attach_id, $file);
                            wp_update_attachment_metadata($attach_id, $attach_data);

                            $media = media_sideload_image($upload_dir['url'] . '/' . $filename, $post_id);

                            if (!empty($media) && !is_wp_error($media)) {
                                $args = array(
                                    'post_type' => 'attachment',
                                    'posts_per_page' => -1,
                                    'post_status' => 'any',
                                    'post_parent' => $post_id
                                );

                                // reference new image to set as featured
                                $attachments = get_posts($args);

                                if (isset($attachments) && is_array($attachments)) {
                                    foreach ($attachments as $attachment) {
                                        // grab source of full size images (so no 300x150 nonsense in path)
                                        $image = wp_get_attachment_image_src($attachment->ID, 'full');
                                        // determine if in the $media image we created, the string of the URL exists
                                        if (strpos($media, $image[0]) !== false) {
                                            // if so, we found our image. set it as thumbnail
                                            if (has_post_thumbnail($post_id)) {
                                                update_post_meta($post_id, '_product_image_gallery', $attachment->ID);
                                            } else {
                                                set_post_thumbnail($post_id, $attachment->ID);
                                            }
                                            // only want one image
                                            break;
                                        }
                                    }
                                }
                            }
                        }
                    }
                    $new_items++;
                }

            } else {
                foreach ($r->posts as $post) {
                    update_post_meta($post->ID, '_stock_status', 'instock');
                    wp_set_post_terms($post->ID, 'instock', 'product_visibility');
                    wc_delete_product_transients($post->ID);
                    $old_items++;
                }
                if (!in_array($node->vmcode->__toString(), $serials)) {
                    $serials[] = $node->vmcode->__toString();
                }
            }
        }
        echo (count($serials) - $new_items) . '-' . $new_items . '-' . (count($serials));
    }

}
