<?php

namespace Blue2\Scruffy\Controllers;

class ProductController
{
    public function __construct()
    {
        $this->registerActions();
        $this->registerFilters();
    }

    private function registerActions()
    {
        add_action('init', [$this, 'registerTaxonomies']);
        add_action('pre_get_posts', [$this, 'customProductFilter'] );
        add_action('pre_get_posts', [$this, 'setShopProductsPerPage'] );
        add_action('init', [$this, 'woocommerceHookAdjustments']);
    }

    private function registerFilters()
    {
        add_filter('manage_edit-product_columns', [$this, 'changeProductAdminColumns'],15 );
        add_filter('woocommerce_pagination_args', [$this, 'customWoocommercePagination']);
        add_filter('woocommerce_product_single_add_to_cart_text', [$this, 'customAddToCartText']);
        add_filter('woocommerce_account_menu_items', [$this, 'updateAccountMenu'], 999 );
        add_filter('woocommerce_sale_flash', [$this, 'removeSaleBadge']);
        add_filter('woocommerce_get_stock_html', [$this, 'hideInStockMessage'], 10, 3 );
    }

    public function registerTaxonomies(){
        $productCondition = new \Blue2\Common\Taxonomy("condition", "Condition", "Conditions", "product", [], $args = [
            'show_ui' => true,
            'query_var' => true,
            'show_admin_column' => true,
        ]);
        $productBrand = new \Blue2\Common\Taxonomy("brand", "Brand", "Brands", "product", [], $args = [
            'show_ui' => true,
            'query_var' => true,
            'show_admin_column' => true,
        ]);
    }


    function customAddToCartText() {
        return __( 'Buy', 'woocommerce' );
    }

    public function changeProductAdminColumns($columns){
        unset( $columns['product_tag'] );
        unset( $columns['featured'] );
        return $columns;
    }

    public function setShopProductsPerPage($query){
        if (!is_admin() && is_shop() && $query->is_main_query()) {
            $query->set( 'posts_per_page', 24 );
        }
    }

    public function customWoocommercePagination($args) {
        $args['prev_text'] = 'Previous';
        $args['next_text'] = 'Next';
        $args['mid_size'] = 0;
        $args['end_size'] = 1;
        $args['show_all'] = false;
        return $args;
    }

    public function customProductFilter($query)
    {
        if (!is_admin() && ($query->is_tax('product_cat') || $query->is_tax('brand')) || (is_shop() &&  $query->is_main_query())) {
            $taxQuery = ['relation' => 'AND'];
            if(isset($_GET['make']) && $_GET['make'] !== '') {
                $brand = $_GET['make'];
                $taxQuery[] = [
                    'taxonomy' => 'brand',
                    'terms' => $brand,
                    'field' => 'slug',
                    'operator' => 'IN'
                ];
                $query->set( 'tax_query', $taxQuery );
            }

            if(isset($_GET['condition']) && $_GET['condition'] !== '') {
                $condition = $_GET['condition'];
                $taxQuery[] = [
                    'taxonomy' => 'condition',
                    'terms' => $condition,
                    'field' => 'slug',
                    'operator' => 'IN'
                ];
                $query->set( 'tax_query', $taxQuery );
            }

            if(isset($_GET['product-category']) && $_GET['product-category'] !== '') {
                $type = $_GET['product-category'];
                $taxQuery[] = [
                    'taxonomy' => 'product_cat',
                    'terms' => $type,
                    'field' => 'slug',
                    'operator' => 'IN'
                ];
                $query->set( 'tax_query', $taxQuery );
            }

            //todo - add price range check when we have the price brackets

            if(isset($_GET['sort-by']) && $_GET['sort-by'] !== '') {
                $sortType = $_GET['sort-by'];
                if($sortType == 'low-to-high'){
                    $query->set('orderby', 'meta_value_num');
                    $query->set('meta_key', '_price');
                    $query->set('order', 'ASC');
                } else if($sortType == 'high-to-low'){
                    $query->set('orderby', 'meta_value_num');
                    $query->set('meta_key', '_price');
                    $query->set('order', 'DESC');
                }
            }

        }
    }

    public function woocommerceHookAdjustments() {
        remove_action('woocommerce_before_shop_loop', 'woocommerce_result_count', 20);
        remove_action('woocommerce_before_shop_loop', 'woocommerce_catalog_ordering', 30);

        remove_action('woocommerce_sidebar', 'woocommerce_get_sidebar', 10 );

        remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_rating', 10 );
        remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_price', 10 );
        remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_meta', 40 );
        remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_sharing', 50 );

        add_action('woocommerce_single_product_summary', [$this, 'customProductStats'], 25);
        add_action('woocommerce_single_product_summary', [$this, 'customPrice'], 25 );
        add_action('woocommerce_single_product_summary', [$this, 'customEnquirySection'], 35);


        remove_action('woocommerce_after_single_product_summary', 'woocommerce_output_product_data_tabs', 10 );
        remove_action('woocommerce_after_single_product_summary', 'woocommerce_upsell_display', 15 );

        remove_action( 'woocommerce_before_main_content', 'woocommerce_breadcrumb', 20, 0 );
    }

    public static function dynamicArchiveTitle() {
        $dynamicTitle = [];
        if(isset($_GET['make']) && $_GET['make'] !== '') {
            $brand = get_term_by('slug', $_GET['make'], 'brand');
            $dynamicTitle[] = $brand->name;
        }
        if(isset($_GET['product-category']) && $_GET['product-category'] !== ''){
            $productCategory = get_term_by('slug', $_GET['product-category'], 'product_cat');
            $dynamicTitle[] = $productCategory->name;
        }
        if(isset($_GET['condition']) && $_GET['condition'] !== '') {
            $condition = get_term_by('slug', $_GET['condition'], 'condition');
            $dynamicTitle[] = $condition->name;
        }
        $title = implode(' - ', $dynamicTitle) ?: 'Products';
        return $title;
    }

    public function customPrice() {
        global $product;
        $saleClass = $product->get_sale_price() ? 'sale-active' : 'sale-inactive'; ?>
        <div class="price">
            <div class="inner-price rrp <?= $saleClass; ?>"><span class="amount"><?= get_woocommerce_currency_symbol() . $product->get_regular_price() . '</span> <span class="price-suffix">RRP</span>'; ?></div>
            <?php if($product->get_sale_price()) { ?><div class="inner-price sale"><?= get_woocommerce_currency_symbol() . $product->get_sale_price() . ' <span class="price-suffix">Our Price</span>'; ?></div><?php } ?>
        </div>
    <?php }

    public function customProductStats() {
        $stats = get_field('product_stats');
        if ($stats) { ?>
            <div class="product-stat-holder">
                <ul>
                    <?php foreach($stats as $stat) { ?>
                        <li>
                            <?php if($stat['font_awesome_icon']) { ?><span class="icon"><i class="<?= $stat['font_awesome_icon'] ?>"></i></span><?php } ?>
                            <span class="label"><?= $stat['label'] ?></span>
                            <span class="value"><?= $stat['value'] ?></span>
                        </li>
                    <?php } ?>
                </ul>
            </div>
        <?php }
    }

    public function customEnquirySection() {
        $perDayPrice = get_field('per_day_price');
        $perWeekPrice = get_field('per_week_price');
        if ($perDayPrice || $perWeekPrice) { ?>
            <div class="product-enquiry-holder">
                <div class="enquiry-prices">
                    <p>This product is also available for hire.</p>
                    <ul>
                       <?php if($perDayPrice) { ?> <li>Per day <strong><?= get_woocommerce_currency_symbol() . $perDayPrice; ?></strong></li><?php } ?>
                        <?php if($perWeekPrice) { ?> <li>Per Week <strong><?= get_woocommerce_currency_symbol() . $perWeekPrice; ?></strong></li><?php } ?>
                    </ul>
                </div>
                <a href="/enquiry/?enquiry=<?= get_the_title(); ?>" class="enquiry-button">Make an enquiry</a>
            </div>
        <?php }
    }

    public function updateAccountMenu($items) {
        unset($items['downloads']);
        return $items;
    }

    public function removeSaleBadge()
    {
        return false;
    }

    public function hideInStockMessage( $html, $product ) {
        $availability = $product->get_availability();
        if ( isset( $availability['class'] ) && 'in-stock' === $availability['class'] ) {
            return '';
        }
        return $html;
    }

}
