import Swiper from 'swiper';

const productCat = () => {
    const sliderCount = $('.product-swiper-by-brand').length;
    for (let i = 1; i <= sliderCount; i++) {
        const sliderName = `.product-slider-${i}`;
        new Swiper(sliderName, {
            breakpoints: {
                0: {
                    spaceBetween: 50,
                    slidesPerView: 1,
                },
                992: {
                    spaceBetween: 50,
                    slidesPerView: 1.5,
                },
                1200: {
                    spaceBetween: 50,
                    slidesPerView: 2,
                },
                1640: {
                    spaceBetween: 50,
                    slidesPerView: 2.5,
                },
            },
            watchOverflow: true,
            pagination: {
                el: '.swiper-pagination',
                type: 'progressbar',
            },
            navigation: {
                nextEl: `.next-${i}`,
                prevEl: `.prev-${i}`,
            },
        });
    }
    $('.custom-button-next').removeClass('swiper-button-disabled');
};

export default productCat;
