<?php get_header(); ?>
    <div class="custom-search-results">
        <div class="container">
            <h1 class="page-title"><?php printf( __( 'Search Results for: %s', 'shape' ), '<span>' . get_search_query() . '</span>' ); ?></h1>
            <?php if ( have_posts() ) { ?>
                <div class="search-output">
                    <div class="row row-eq-height">

                    <?php while (have_posts()) {
                        the_post(); ?>
                        <div class="col-xl-6 search-col">
                            <div class="search-result">
                                <a href="<?php the_permalink(); ?>">
                                    <h2><?php the_title(); ?></h2>
                                    <div class="description">
                                        <?php the_excerpt(); ?>
                                    </div>
                                </a>
                            </div>
                        </div>

                    <?php } ?>
                </div>
                </div>
                <div class="custom-pagination">
                    <?php
                    the_posts_pagination([
                        'mid_size' => 1,
                        'prev_text' => __('Previous', 'textdomain'),
                        'next_text' => __('Next', 'textdomain'),
                        'before_page_number' => '<span class="meta-nav screen-reader-text">' . __('', '') . ' </span>',
                    ]); ?>
                </div>
            <?php } ?>
        </div>
    </div>
<?php get_footer(); ?>
