<?php
$altCompanyLogo = get_field('alternate_company_logo', 'option');
$telephone = get_field('contact_phone_number', 'option');
$email = get_field('contact_email_address', 'option');
$fax = get_field('contact_fax_number', 'option');
$footerForm = get_field('footer_form', 'option');
$footerLogo = get_field('footer_logo', 'option');
?>

<footer class="site-footer">
    <div class="footer-holder">
        <div class="primary-section">
            <div class="top-row">
                <img src="<?= $altCompanyLogo['url']; ?>">
            </div>
            <div class="middle-row">
                <div class="menu-area">
                    <h3>Products</h3>
                    <?php
                    if (has_nav_menu( 'footer_products_menu' )) {
                        wp_nav_menu(['theme_location' => 'footer_products_menu', 'menu_class' => '']);
                    }
                    ?>
                </div>
                <div class="menu-area">
                    <h3>Services</h3>
                    <?php
                    if (has_nav_menu( 'footer_services_menu' )) {
                        wp_nav_menu(['theme_location' => 'footer_services_menu', 'menu_class' => '']);
                    }
                    ?>
                </div>
                <div class="menu-area">
                    <h3>Company</h3>
                    <?php
                    if (has_nav_menu( 'footer_company_menu' )) {
                        wp_nav_menu(['theme_location' => 'footer_company_menu', 'menu_class' => '']);
                    }
                    ?>
                </div>
                <div class="menu-area">
                    <h3>Customer Service</h3>
                    <?php
                    if (has_nav_menu( 'footer_customer_service_menu' )) {
                        wp_nav_menu(['theme_location' => 'footer_customer_service_menu', 'menu_class' => '']);
                    }
                    ?>
                </div>
                <div class="menu-area">
                    <ul>
                        <?php if($telephone) { ?><li><i class="fas fa-phone"></i> <a href="tel:<?= $telephone; ?>"><?= $telephone; ?></a></li><?php } ?>
                        <?php if($fax) { ?><li><i class="fal fa-fax"></i> <a href="tel:<?= $fax; ?>"><?= $fax; ?></a></li><?php } ?>
                        <?php if($email) { ?><li class="email"><i class="far fa-envelope"></i> <a href="mailto:<?= $email; ?>"><?= $email; ?></a></li><?php } ?>
                    </ul>
                </div>
            </div>
            <div class="bottom-row d-none d-lg-flex">
                <?php
                if (has_nav_menu( 'footer_documentation_menu' )) {
                    wp_nav_menu(['theme_location' => 'footer_documentation_menu', 'menu_class' => '']);
                }
                ?>
                <div class="credit">
                    <p>Website by <?php echo do_shortcode( '[blue2_logo type="dark"]' ); ?></p>
                </div>
            </div>
        </div>
        <div class="secondary-section">
            <?php if (have_rows('social_media_channels', 'option')) { ?>
                <ul class="footer-socials">
                    <li>Follow Us:</li>
                    <?php
                    while (have_rows('social_media_channels', 'option')) {
                        the_row();
                        ?>
                        <li>
                            <a href="<?php the_sub_field('full_url'); ?>" target="_blank" rel="noopener">
                                <span class="fa-stack fa-2x">
                                  <i class="fas fa-circle fa-stack-2x"></i>
                                  <i class="<?php the_sub_field('fa5_icon_class'); ?> fa-stack-1x fa-inverse"></i>
                                </span>
                            </a>
                        </li>
                        <?php
                    }
                    ?>
                </ul>
            <?php } ?>

            <?php if($footerForm) { ?>
                <div class="footer-form">
                    <?= $footerForm; ?>
                </div>
            <?php } ?>


            <div class="copyright">
                <?php if($footerLogo) { ?><img src="<?= $footerLogo['url']; ?>" class="footer-logo" alt="<?= $footerLogo['url']; ?>"><?php } ?>
                <p>&copy; <?= date("Y"); ?> <?php the_field('footer_copyright_message', 'option'); ?></p>
            </div>

            <div class="mobile-bottom">
                <?php
                if (has_nav_menu( 'footer_documentation_menu' )) {
                    wp_nav_menu(['theme_location' => 'footer_documentation_menu', 'menu_class' => '']);
                }
                ?>
                <div class="credit">
                    <p>Website by <?php echo do_shortcode( '[blue2_logo type="dark"]' ); ?></p>
                </div>
            </div>

        </div>
    </div>
</footer>
