const common = () => {
    if ($('#map').length) {
        const google = window.google;
        const mapLng = $('#map')
            .data('lng');
        const mapLat = $('#map')
            .data('lat');
        const mapZoom = $('#map')
            .data('zoom');
        const mapCenter = { lat: mapLat, lng: mapLng };
        const map = new google.maps.Map(document.getElementById('map'), {
            zoom: mapZoom,
            center: mapCenter,
            scrollWheel: false,
            streetViewControl: false,
        });
        new google.maps.Marker({
            position: mapCenter,
            map,
        });
    }

    $('.search.right-item').on('click', function() {
        $('.custom-search-form').addClass('active');
        $('.custom-search-form').delay(300)
            .fadeIn(function() {
                $('.right-section').css('overflow', 'visible');
                $(this).find('.search-field')
                    .focus();
            });
    });

    $('.search-field').on('focusout', function() {
        $('.right-section').css('overflow', 'hidden');
        $('.custom-search-form').removeClass('active');
    });
};

export default common;
