<?php

$title = get_field('title') ?: 'Hire';
$subtitle = get_field('subtitle');
$description = get_field('description');

$deliveryTitle = get_field('information_title');
$deliveryDesc = get_field('information_description');
$deliveryRows = get_field('information_rows');

?>

<div class="custom-hire-template">

    <div class="hero-section">
        <div class="hero-holder">
            <div class="top-hero-section" style="background-image:url('<?= get_the_post_thumbnail_url(); ?>')"></div>
            <div class="bottom-hero-section">
                <div class="container">
                    <div class="row">
                        <div class="col-lg-6 primary-col">
                            <div class="primary-holder">
                                <div class="top underlay-active">
                                    <h1><?= $title; ?></h1>
                                </div>
                                <div class="bottom">
                                    <?php if($subtitle) { ?><h2><?= $subtitle; ?></h2><?php } ?>
                                    <div class="description"><?= $description; ?></div>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-6 secondary-col d-flex align-items-center justify-content-center">
                            <?php
                            $ctaFile = get_field('hire_catalogue');
                            ?>
                            <div class="secondary-holder">
                                <?php if($ctaFile) {
                                    $ctaText = 'Download our Hire Catalogue:';
                                    $ctaButtonText = 'Download PDF'; ?>
                                    <div class="hero-cta-holder">
                                        <div class="text"><?= $ctaText; ?></div>
                                        <div class="cta"><a href="<?= $ctaFile['url']; ?>" target="_blank"><?= $ctaButtonText; ?></a></div>
                                    </div>
                                <?php } ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="delivery-information">
        <div class="container">
            <h2><?= $deliveryTitle; ?></h2>
            <?php if($deliveryRows) { ?>
                <div class="delivery-rows">
                    <?php foreach($deliveryRows as $row) { ?>
                        <div class="delivery-row">
                            <div class="area"><?= $row['area']; ?></div>
                            <div class="distance"><?= $row['distance']; ?></div>
                            <div class="price"><?= get_woocommerce_currency_symbol() . $row['price']; ?></div>
                        </div>
                    <?php } ?>
                </div>
            <?php } ?>
            <?php if($deliveryDesc) { ?><div class="description"><?= $deliveryDesc ?></div><?php } ?>
        </div>
    </div>
</div>
