<?php
get_header();
$object = get_queried_object();
$companyLogoAlt = get_field('alternate_company_logo', 'option');
$productCatLoopArgs = [
    'post_type' => 'product',
    'post_status' => 'publish',
    'posts_per_page' => -1,
    'tax_query' => [
        [
            'taxonomy' => $object->taxonomy,
            'field'    => 'slug',
            'terms'    => [$object->slug]
        ]
    ]
];
$products = new WP_Query($productCatLoopArgs);
$productIDsByCategory = [];
if ( $products->have_posts() ) {
    while ( $products->have_posts() ) {
        $products->the_post();
        $term = get_the_terms(get_the_id(), 'product_cat')[0];
        $productIDsByCategory[$term->slug][] = get_the_id();
    }  wp_reset_postdata();
    ksort($productIDsByCategory);
}
//todo - limit arrays to 10 per brand
?>

<div class="custom-tax-archive custom-taxonomy-product-cat">
    <div class="container">
        <?php if ( function_exists('yoast_breadcrumb') ) {
            yoast_breadcrumb( '<div class="custom-breadcrumbs"><p id="breadcrumbs">','</p></div>' );
        } ?>

        <div class="taxonomy-top">
            <h1><?= $object->name ?></h1>
            <?php get_template_part('/templates/sections/category-filter-bar'); ?>
        </div>

        <?php if($productIDsByCategory) { ?>
            <div class="products-by-brand-output">
                <?php
                $carouselCount = 0;
                foreach($productIDsByCategory as $key => $value) {
                    $category = get_term_by('slug', $key, 'product_cat');
                    $carouselCount++; ?>
                    <div class="brand-block">
                        <h3><?= $category->name; ?> <div class="view-all"><a href="<?= '/products/?product-category=' . $category->slug . '&make=' . $object->slug; ?>"><?= 'View all ' . $object->name . ' ' . strtolower($category->name); ?></a></div></h3>
                        <div class="custom-nav-directions">
                            <div class="custom-button-prev <?= 'prev-' . $carouselCount; ?> custom-nav-direction"><i class="far fa-arrow-left"></i></div>
                            <div class="custom-button-next <?= 'next-' . $carouselCount; ?> custom-nav-direction"><i class="far fa-arrow-right"></i></div>
                        </div>
                        <div class="swiper-container product-swiper-by-brand <?= 'product-slider-' . $carouselCount; ?>">
                            <div class="swiper-wrapper">
                                <?php foreach($value as $id) {
                                    $product = wc_get_product($id);
                                    $image = get_the_post_thumbnail_url($id, 'product-card-image') ?: $companyLogoAlt['url'];
                                    $imageClass = get_the_post_thumbnail_url($id) ? 'featured-image' : 'default-image';
                                    ?>
                                    <div class="swiper-slide">
                                        <div class="product-item">
                                            <a href="<?= get_permalink( $product->get_id() ); ?>">
                                                <div class="image-holder <?= $imageClass; ?>"><img src="<?= $image; ?>" alt="<?php the_title(); ?>"></div>
                                                <h2 title="<?= $product->get_name(); ?>"><?= $product->get_name(); ?></h2>
                                                <div class="price"><?= get_woocommerce_currency_symbol() . $product->get_price(); ?></div>
                                                <span class="product-overlay">
                                                      <div class="product-page-box">Go to product page</div>
                                                </span>
                                            </a>
                                        </div>
                                    </div>
                                <?php } ?>
                            </div>
                            <div class="swiper-pagination"></div>
                        </div>
                    </div>
                <?php } ?>
            </div>
        <?php } else { ?>
            <div class="no-product-results">
                <?php the_field('no_products_category_page_message', 'option') ?>
            </div>
        <?php } ?>
    </div>
</div>
<?php get_footer(); ?>
