<div class="custom-single-post">
    <div class="container">
        <?php if ( function_exists('yoast_breadcrumb') ) {
            yoast_breadcrumb( '<div class="custom-breadcrumbs"><p id="breadcrumbs">','</p></div>' );
        } ?>
        <div class="row">
            <div class="order-lg-2 col-lg-6 image-col">
                <?php if(get_the_post_thumbnail_url()) { ?>
                    <div class="image-holder">
                        <img src="<?php the_post_thumbnail_url(); ?>" alt="<?php the_title(); ?>">
                    </div>
                <?php } ?>
            </div>
            <div class="order-lg-1 col-lg-6 content-col">
                <div class="date"><?= get_the_date('d.m.Y') ?></div>
                <h1><?php the_title(); ?></h1>
                <div class="content"><?php the_content(); ?></div>
            </div>
        </div>
    </div>


    <?php

    $latestNewsArgs = [
        'post_type' => 'post',
        'post_status' => 'publish',
        'posts__not_in' => [get_the_id()],
        'posts_per_page' => 3
    ];

    $latestNewsQuery = new WP_Query($latestNewsArgs);
    $companyLogo = get_field('alternate_company_logo', 'option');
    if($latestNewsQuery->have_posts()) { ?>
        <div class="latest-news news-output">
            <div class="container">
                <h2>Latest News</h2>
                <div class="row">
                    <?php while($latestNewsQuery->have_posts()) {
                        $latestNewsQuery->the_post();
                        $image = get_the_post_thumbnail_url() ?: $companyLogo['url'];
                        $imageClass = get_the_post_thumbnail_url() ? 'set-image' : 'default-image';
                        ?>
                        <div class="news-col col-md-6 col-xl-4">
                            <div class="date"><?= get_the_date('d.m.Y') ?></div>
                            <div class="news-item">
                                <a href="<?php the_permalink(); ?>">
                                    <div class="image-section <?= $imageClass; ?>">
                                        <img src="<?= $image; ?>" alt="<?php the_title(); ?>">
                                    </div>
                                    <div class="content-section">
                                        <h2><?php the_title(); ?></h2>
                                        <div class="read-article">Read the article <i class="far fa-arrow-right"></i></div>
                                    </div>
                                </a>
                            </div>
                        </div>
                    <?php } wp_reset_postdata(); ?>
                </div>
            </div>
        </div>
    <?php } ?>

</div>
