<?php
$companyLogo = get_field('company_logo', 'option');
?>

<nav class="header-nav">
    <div class="left-section">
        <a class="navbar-brand" href="<?= esc_url(home_url('/')); ?>">
            <img src="<?= $companyLogo['url']; ?>" alt="<?php bloginfo('name'); ?>" />
        </a>
    </div>

    <div class="middle-section">
        <div class="collapse navbar-collapse" id="navbarSupportedContent">
            <?php
            if (has_nav_menu('main_menu')) {
                wp_nav_menu(['theme_location' => 'main_menu', 'menu_class' => 'navigation']);
            }
            ?>
        </div>
    </div>

    <div class="right-section">
        <div class="cart right-item">
            <a href="<?= wc_get_cart_url(); ?>"><i class="fas fa-shopping-cart" title="Cart"></i></a>
        </div>
        <div class="account right-item">
            <a href="<?= get_permalink( get_option('woocommerce_myaccount_page_id') ); ?>"><i class="fas fa-user" title="My Account"></i></a>
        </div>
        <button class="navbar-toggler mobile-toggle" type="button" data-toggle="collapse" data-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
            <i class="far fa-bars mobile-nav"></i>
        </button>
        <div class="search right-item">
            <i class="fal fa-search" title="Search"></i>
            <form role="search" method="get" class="custom-search-form" action="/">
                <div class="search-holder">
                    <input type="search" class="search-field" placeholder="Search..." value="" name="s" />
                </div>
            </form>
        </div>
    </div>
</nav>

<div class="mobile-navigation">
    <?php
    if (has_nav_menu('main_menu')) {
        wp_nav_menu(['theme_location' => 'main_menu', 'menu_class' => 'navigation']);
    }
    ?>
</div>
