<?php
$cards = get_sub_field('cards');
$cardsPerRow = get_sub_field('cards_per_row');
$companyLogo = get_field('alternate_company_logo', 'option');

switch($cardsPerRow) {
    case 2:
        $col = 'col-lg-6';
        $cardClass = 'two-card-row';
        break;
    case 3:
        $col = 'col-lg-6 col-xl-4';
        $cardClass = 'three-card-row';
        break;
    case 4:
        $col = 'col-lg-6 col-xl-3';
        $cardClass = 'four-card-row';
        break;
}
if($cards) {?>
    <div class="flexible-section card-section <?= $cardClass; ?>">
        <div class="container">
            <div class="row">
                <?php foreach($cards as $card) {
                    $image = $card['card_image'] ? $card['card_image']['url'] : $companyLogo['url'];
                    $imageClass = $card['card_image'] ? 'set-image' : 'default-image'; ?>
                    <div class="<?= $col; ?> card-col">
                        <div class="card-item">
                            <?php if($card['card_cta']) { ?><a href="<?= $card['card_cta']['url']; ?>"><?php } ?>
                                <div class="image-section <?= $imageClass; ?>">
                                    <img src="<?= $image; ?>" alt="<?= $card['card_title']; ?>">
                                </div>
                                <div class="content-section">
                                    <h2><?= $card['card_title']; ?></h2>
                                    <div class="description"><?= $card['card_description']; ?></div>
                                </div>
                            <?php if($card['card_cta']) { ?></a><?php } ?>
                        </div>
                    </div>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
