<?php
$overlays = get_sub_field('overlay_panels');
$heroType = get_sub_field('hero_type');
$heroRightType = get_sub_field('hero_right_type');
$heroImage = get_sub_field('image');
$heroVideo = get_sub_field('video');
$cta = get_sub_field('cta');
$title = get_sub_field('main_title');
$subtitle = get_sub_field('subtitle');
$underlay = get_sub_field('use_green_underlay_on_title') ? 'underlay-active' : 'underlay-inactive';
$companyLogo = get_field('company_logo', 'option');
?>
<div class="flexible-section hero-section <?= 'type-' . $heroType; ?>">

    <div class="hero-holder">
        <div class="top-hero-section" style="background-image:url('<?= $heroImage['url']; ?>')">
            <?php if($heroType == 'video' && $heroVideo) { ?>
                <video id="hero-video" loop>
                    <source src="<?= $heroVideo['url']; ?>" type="video/mp4">
                </video>
            <?php } ?>

            <?php if($overlays) { ?>
                <div class="hero-title-overlay-active">
                    <?php if($heroType == 'video' && $heroVideo) { ?>
                        <div class="play-video"><i class="fas fa-play-circle"></i> <span class="button-text">Watch the video</span></div>
                    <?php }
                    if($title) { ?>
                        <h1><?= $title; ?></h1>
                    <?php } ?>
                </div>
            <?php } ?>

        </div>
        <?php if($overlays) { ?>
            <div class="overlays">
                <?php foreach($overlays as $overlay) {
                    $triggerID = $overlay['type'] == 'trigger' ? $overlay['trigger'] : "";
                    $triggerClass = $overlay['type'] == 'trigger' ? 'active-trigger' : "";
                    $url = $overlay['type'] == 'trigger' ? '#' . $overlay['trigger'] : $overlay['link']['url'];

                    if($overlay['type'] == 'trigger') {
                        $triggerTaxonomy = $overlay['trigger_taxonomy'];
                        $triggerTerm = $overlay['trigger'];
                        $termData = get_term_by('slug', $triggerTerm, $triggerTaxonomy); ?>
                    <?php } ?>

                    <div class="overlay-section">
                        <a href="<?= $url; ?>" id="<?= $triggerID ?>" class="<?= $triggerClass; ?> desktop-overlay-link" <?php if($overlay['type'] == 'trigger') { echo 'data-taxonomy="' . $triggerTaxonomy . '" data-title="' . $termData->name . '" data-description="' . $termData->description . '" '; } ?>">
                        <div class="top"><h3><?= $overlay['title']; ?></h3><i class="far fa-arrow-right"></i></div>
                        <span class="description"><?= $overlay['description']; ?></span>
                        </a>
                        <a href="<?= $overlay['link']['url']; ?>"  class="mobile-overlay-link">
                            <div class="top"><h3><?= $overlay['title']; ?></h3><i class="far fa-arrow-right"></i></div>
                            <span class="description"><?= $overlay['description']; ?></span>
                        </a>
                    </div>

                <?php } ?>
            </div>
        <?php } ?>

        <div class="overlay-expanded">
            <?php
            $uncategorised = get_term_by('slug', 'uncategorized', 'product_cat');
            $categories = get_terms('product_cat', ['hide_empty' => false, 'exclude' => $uncategorised->term_id]); ?>
            <div class="category-output">
                <div class="category-grid">
                    <?php foreach($categories as $cat) {
                        $thumbnailID = get_term_meta( $cat->term_id, 'thumbnail_id', true );
                        $image = wp_get_attachment_url( $thumbnailID ); ?>
                        <div class="category-overlay-item">
                            <a href="<?= '/products/?product-category=' . $cat->slug .  '&'; ?>">
                                <div class="image-holder">
                                    <img src="<?= $image; ?>" alt="<?= $cat->name; ?>">
                                </div>
                                <div class="name">
                                    <div class="text"><?= $cat->name; ?></div>
                                    <div class="arrow">
                                        <i class="far fa-long-arrow-right"></i>
                                    </div>
                                </div>
                            </a>
                        </div>
                    <?php } ?>
                </div>
            </div>
            <div class="information-panel">
                <div class="inner">
                    <div class="top">
                        <h2 class="title"></h2>
                        <i class="far fa-times close-overlay"></i>
                    </div>
                    <div class="description"></div>
                    <div class="logo"><img src="<?= $companyLogo['url']; ?>" alt="<?php bloginfo('name'); ?>"></div>
                </div>
            </div>
        </div>
    </div>
    <?php $topSectionClass = $overlays ? 'hero-has-overlays' : ""; ?>
    <div class="bottom-hero-section">
        <div class="container">
            <div class="row">
                <div class="col-lg-6 primary-col">
                    <div class="primary-holder">
                        <div class="top <?= $underlay . ' ' . $topSectionClass;  ?>">
                            <?php if($heroType == 'video' && $heroVideo) { ?>
                                <div class="play-video"><i class="fas fa-play-circle"></i> <span class="button-text">Watch the video</span></div>
                            <?php }
                            if($title) { ?>
                                <h1><?= $title; ?></h1>
                            <?php } ?>
                        </div>
                        <?php $ctaClass = $cta ? 'cta-active' : ""; ?>
                        <div class="bottom <?= $ctaClass; ?>">
                            <?php if($subtitle) { ?><h2><?= $subtitle; ?></h2><?php } ?>
                            <div class="description"><?php the_sub_field('description'); ?></div>
                            <?php if($cta) { ?><a href="<?= $cta['url']; ?>"><?= $cta['title']; ?> <i class="far fa-arrow-right"></i></a><?php } ?>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6 secondary-col d-flex align-items-center justify-content-center">
                    <div class="secondary-holder">
                        <?php if($heroRightType == 'social-media' && have_rows('social_media_channels', 'option')) { ?>
                            <div class="hero-social-holder">
                                <h3>Follow us:</h3>
                                <ul class="hero-socials">
                                    <?php while (have_rows('social_media_channels', 'option')) {
                                        the_row(); ?>
                                        <li>
                                            <a href="<?php the_sub_field('full_url'); ?>" target="_blank" rel="noopener">
                                            <span class="fa-stack fa-2x">
                                              <i class="fas fa-circle fa-stack-2x"></i>
                                              <i class="<?php the_sub_field('fa5_icon_class'); ?> fa-stack-1x fa-inverse"></i>
                                            </span>
                                            </a>
                                        </li>
                                    <?php } ?>
                                </ul>
                            </div>
                        <?php } elseif($heroRightType == 'cta') {
                            $ctaText = get_sub_field('hero_right_cta_text');
                            $ctaType = get_sub_field('hero_right_cta_type');
                            $ctaFile = get_sub_field('hero_right_cta_file');
                            $ctaLink = get_sub_field('hero_right_cta_link');
                            $ctaButtonURL = $ctaType == 'file' ? $ctaFile['url'] : $ctaLink['url'];
                            $ctaButtonText = $ctaType == 'file' ? 'Download File' : $ctaLink['title'];
                            $target = $ctaType == 'file' ? "_blank" : "_self";
                            ?>
                            <div class="hero-cta-holder">
                                <div class="text"><?= $ctaText; ?></div>
                                <div class="cta"><a href="<?= $ctaButtonURL; ?>" target="<?= $target; ?>"><?= $ctaButtonText; ?></a></div>
                            </div>
                        <?php } elseif($heroRightType == 'quote') {
                            $quoteText = get_sub_field('hero_right_quote_text');
                            $quoteBy = get_sub_field('hero_right_quote_by'); ?>
                            <div class="hero-quote">
                                <div class="quote-text"><?= $quoteText; ?></div>
                                <div class="quote-by"><?= $quoteBy; ?></div>
                            </div>
                        <?php } ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
