<?php
$object = get_queried_object();
$companyLogoAlt = get_field('alternate_company_logo', 'option');
$productCatLoopArgs = [
    'post_type' => 'product',
    'tax_query' => [
        [
            'taxonomy' => $object->taxonomy,
            'field'    => 'slug',
            'terms'    => [$object->slug]
        ]
    ]
];
$products = new WP_Query($productCatLoopArgs);
$productIDsByBrand = [];
if ( $products->have_posts() ) {
    while ( $products->have_posts() ) {
        $products->the_post();
        $term = get_the_terms(get_the_id(), 'brand')[0];
        $productIDsByBrand[$term->slug][] = get_the_id();
    }  wp_reset_postdata();
}

?>

<div class="custom-tax-archive custom-taxonomy-product-cat">
    <div class="container">
        <?php if ( function_exists('yoast_breadcrumb') ) {
            yoast_breadcrumb( '<div class="custom-breadcrumbs"><p id="breadcrumbs">','</p></div>' );
        } ?>

        <div class="taxonomy-top">
            <h1><?= $object->name ?></h1>
        </div>

        <div class="products-by-brand-output">
            <?php foreach($productIDsByBrand as $key => $value) {
                $brand = get_term_by('slug', $key, 'brand'); ?>
                <div class="brand-block">
                    <h3><?= $brand->name; ?> <div class="view-all"><a href="<?= get_category_link($brand->term_id); ?>"><?= 'View all ' . $brand->name ?></a></div></h3>
                    <div class="swiper-container product-swiper-by-brand">
                        <div class="swiper-wrapper">
                            <?php foreach($value as $id) {
                                $product = wc_get_product($id);
                                $image = get_the_post_thumbnail_url($id) ?: $companyLogoAlt['url'];
                                $imageClass = get_the_post_thumbnail_url($id) ? 'featured-image' : 'default-iamge';
                                ?>
                                <div class="swiper-slide">
                                    <div class="product-item">
                                        <a href="<?= get_permalink( $product->get_id() ); ?>">
                                            <div class="image-holder <?= $imageClass; ?>"><img src="<?= $image; ?>"></div>
                                            <h2><?= $product->get_name(); ?></h2>
                                            <div class="price"><?= get_woocommerce_currency_symbol() . $product->get_price(); ?></div>
                                        </a>
                                    </div>
                                </div>
                            <?php } ?>
                        </div>
                    </div>
                </div>
            <?php } ?>
        </div>
    </div>
</div>
