<?php

namespace Blue2\Scruffy\Controllers;

class ProductController
{
    public function __construct()
    {
        $this->registerActions();
        $this->registerFilters();
    }

    private function registerActions()
    {
        add_action('init', [$this, 'registerTaxonomies']);
    }

    private function registerFilters()
    {
        add_filter( 'manage_edit-product_columns', [$this, 'changeProductAdminColumns'],15 );
    }


    public function registerTaxonomies(){
        $productCondition = new \Blue2\Common\Taxonomy("condition", "Condition", "Conditions", "product", [], $args = [
            'show_ui' => true,
            'query_var' => true,
            'show_admin_column' => true,
        ]);
        $productBrand = new \Blue2\Common\Taxonomy("brand", "Brand", "Brands", "product", [], $args = [
            'show_ui' => true,
            'query_var' => true,
            'show_admin_column' => true,
        ]);
    }


    function changeProductAdminColumns($columns){
        unset( $columns['product_tag'] );
        unset( $columns['featured'] );
        return $columns;
    }

}
