<?php
/**
 * Service - Banner Section
 *
 * Flexible content section for 'service_banner' section.
 *
 * @package Fishers_Theme
 */

$title = get_sub_field('title');
$content = get_sub_field('content');
$button = get_sub_field('button');
$image = get_sub_field('image');
$style = get_sub_field('style');
$layout = get_sub_field('layout');

if($layout == "content right"){
    $layoutClass = 'content-right';
    $aos = 'data-aos="fade-left"';
}else{
    $layoutClass = 'content-left';
    $aos = 'data-aos="fade-right"';
}

?>

<section class="s-serviceBanner s-serviceBanner--<?= esc_attr($style); ?>" data-full>
    <?php if ($image) { ?>
        <div class="s-serviceBanner__imgWrap">
            <?= Blue2\Scruffy\Utils::acf_img($image, [
                'class'     => 's-serviceBanner__img',
                'size'      => 'banner'
            ]); ?>
        </div>
    <?php } ?>
    <div class="contain">
        <div class="s-serviceBanner__box flow s-serviceBanner__box--<?= esc_attr($layoutClass); ?>" <?= $aos; ?>>
            <h2><?= $title; ?></h2>
            <?= $content; ?>
            <?php if($button['link'] != ""){ 
                Blue2\Scruffy\Utils::Button($button);
            }?>
        </div>
    </div>
</section>
