<?php
/**
 * Post Single Template
 *
 * @package Fishers_Theme
 */

$feat_image = get_field('feat_image');

?>

<main class="l-main">
    <section class="p-single">
        <div class="contain contain-medium">
            <div class="p-single__grid">

                <div class="p-single__head">
                    <h1 class="ff-alt fw-medium text-mid"><?php the_title(); ?></h1>
                    <time class="text-primary fw-medium" datetime="<?php the_date('d-m-Y'); ?>"><?= get_the_date('jS F Y'); ?></time>
                </div>

                <div class="p-single__body flow">
                    <?php
                    if ($feat_image) {
                        echo \Blue2\Scruffy\Utils::acf_img($feat_image, [
                            'class' => 'mb-4'
                        ]);
                    }

                    the_content();
                    ?>

                    <footer class="p-single__foot">

                        <div class="p-single__share bg-primary-shade text-white d-flex align-items-center fs-8" aria-labelledby="share-title">
                            <span id="share-title" class="fw-medium">Share this article</span>

                            <?php $share_links = \Blue2\Scruffy\Utils::share_link([
                                'url'   => 'https://alistairshepherd.uk'
                            ]); ?>

                            <a
                                class="p-single__shareLink text-decoration-none fs-4"
                                href="<?= $share_links['facebook']; ?>"
                                target="blank"
                                rel="noopener noreferrer"
                                onclick="javascript:window.open(this.href, '', 'menubar=no,toolbar=no,resizable=yes,scrollbars=yes,height=700,width=526');return false;">
                                <span class="fab fa-facebook" aria-hidden="true"></span>
                                <span class="visually-hidden">Facebook</span>
                            </a>

                            <a
                                class="p-single__shareLink text-decoration-none fs-4"
                                href="<?= $share_links['twitter']; ?>"
                                target="blank"
                                rel="noopener noreferrer"
                                onclick="javascript:window.open(this.href, '', 'menubar=no,toolbar=no,resizable=yes,scrollbars=yes,height=400,width=600');return false;">
                                <span class="fab2 fa-twitter-circle" aria-hidden="true"></span>
                                <span class="visually-hidden">Twitter</span>
                            </a>

                            <a
                                class="p-single__shareLink text-decoration-none fs-4"
                                href="<?= $share_links['linkedin']; ?>"
                                target="blank"
                                rel="noopener noreferrer"
                                onclick="javascript:window.open(this.href, '', 'menubar=no,toolbar=no,resizable=yes,scrollbars=yes,height=700,width=600');return false;">
                                <span class="fab2 fa-linkedin-circle" aria-hidden="true"></span>
                                <span class="visually-hidden">LinkedIn</span>
                            </a>

                            <a
                                class="p-single__shareLink text-decoration-none fs-5"
                                href="<?= $share_links['email']; ?>">
                                <span class="fab2 fa-envelope" aria-hidden="true"></span>
                                <span class="visually-hidden">Email</span>
                            </a>
                        </div>

                        <div class="p-single__nav ff-alt fw-bold fs-7">
                            <?php previous_post_link(
                                '%link',
                                '<span class="far fa-angle-left" aria-hidden="true"></span> Previous Article'
                            ); ?>
                            <?php next_post_link(
                                '%link',
                                'Next Article <span class="far fa-angle-right" aria-hidden="true"></span>'
                            ); ?>
                        </div>

                    </footer>
                </div>

                <div class="p-single__support">
                    <h2 class="ff-alt fw-bold text-mid fs-7 mb-4">Proud to support</h2>

                    <div class="p-single__supportRow">
                        <div class="p-single__supportWrap">
                            <img src="<?= get_template_directory_uri(); ?>/dist/images/chas.jpg" width="186" height="88" alt="" loading="lazy">
                        </div>
                        <div class="p-single__supportWrap">
                            <img src="<?= get_template_directory_uri(); ?>/dist/images/scottish-tourism.jpg" width="222" height="88" alt="" loading="lazy">
                        </div>
                    </div>
                </div>

                <div class="p-single__sidebar">
                    <?php get_template_part('templates/post/sidebar'); ?>
                </div>
            </div>
        </div>
    </section>

    <?php
    // related posts section
    $related = get_posts([
        'post__not_in'  => [$post->ID],
        'category__in'  => wp_get_post_categories($post->ID),
        'numberposts'   => 2
    ]);
    get_template_part('templates/parts/related-news', null, [
        'title' => 'You may also like...',
        'posts' => $related
    ]);
    ?>
</main>
