const interval = 5000;

const animOptions = {
    duration: 750,
    fill: 'forwards',
    easing: 'ease-in-out'
};

const hide = el => {
    if (!el) { return; };

    el.animate([
        {
            //transformOrigin: 'bottom',
            //transform: 'translateY(0) rotateX(0deg)',
            visibility: 'visible',
            opacity: 1
        },
        {
            //transformOrigin: 'bottom',
            //transform: 'translateY(-100%) rotateX(90deg)',
            visibility: 'hidden',
            opacity: 0
        }
    ], animOptions);
};

const show = el => {
    if (!el) { return; };

    el.animate([
        {
            //transformOrigin: 'top',
            //transform: 'translateY(100%) rotateX(-90deg)',
            visibility: 'hidden',
            opacity: 0
        },
        {
            //transformOrigin: 'top',
            //transform: 'translateY(0) rotateX(0deg)',
            visibility: 'visible',
            opacity: 1
        }
    ], animOptions);
};

const animation = (current, next) => {
    hide(current);
    show(next);
};

const loopIndex = (num, max) => {
    if (num >= max) {
        return 0;
    }
    return num;
};

const init = hero => {
    if (!hero) { return; };

    const slides = hero.querySelectorAll('.s-hero__title');
    if (!slides) { return; };

    let current = 0;
    let isHanging = false;

    setInterval(() => {
        // don't request another animation frame if the last hasn't run
        if (isHanging) { return; };

        isHanging = true;
        window.requestAnimationFrame(() => {
            isHanging = false;

            let next = current + 1;
            next = loopIndex(next, slides.length);

            animation(
                slides[current],
                slides[next]
            );

            current++;
            current = loopIndex(current, slides.length);
        });
    }, interval);
};

export default () => {
    // if user prefers reduced motion, don't run animation
    const mediaQuery = window.matchMedia('(prefers-reduced-motion: reduce)');
    if (mediaQuery.matches) {
        return;
    }

    const heroes = document.querySelectorAll('.s-hero');
    if (!heroes) { return; };

    heroes.forEach(hero => init(hero));
};
