<?php
/**
 * Hero Section
 *
 * Flexible content section for 'hero' section.
 *
 * @package Fishers_Theme
 */

$titles = get_sub_field('titles');

// flatten ACF repeeater
$titles = array_column($titles, 'title');

?>

<section class="s-hero bg-primary text-white flex-column" data-full>
    <?php get_template_part('templates/parts/illustration', null, [
        'class' => 'b-illustration--bg'
    ]); ?>
    <div class="contain s-hero__contain">
        <a href="#first-content" class="s-hero__scroll fw-medium" aria-hidden>
            <span class="scroller"></span>
            <span class="text">Scroll</span>
            
        </a>
        <div class="s-hero__titles text-center" aria-label="<?= esc_attr(implode(' ', $titles)); ?> Fishers.">
            <?php foreach ($titles as $i => $title) {
                printf(
                    '<%1$s class="s-hero__title ff-alt fw-medium text-white">
                        %2$s
                    </%1$s>',
                    $i === 0 ? 'h1' : 'span',
                    $title
                );
            } ?>
            <span class="s-hero__title">
                <img class="s-hero__logo" src="<?= get_template_directory_uri(); ?>/dist/images/fishers-white.svg" width="213.1" height="40.6" alt="Fishers" loading="lazy">
            </span>
        </div>
    </div>
    <?php if (has_nav_menu('services')) { ?>
        <div class="s-hero__footer text-center position-relative">
            <h2 class="visually-hidden">Our Services</h2>
            <?php wp_nav_menu([
                'theme_location'    => 'services',
                'menu_container'    => 'ul',
                'menu_class'        => 'b-serviceButtons s-hero__footerList contain',
                'items_wrap'        => '<ul id="%1$s" class="%2$s" role="list">%3$s</ul>',
            ]); ?>
        </div>
    <?php } ?>
</section>
