<?php
/**
 * Locations Section
 *
 * Flexible content section for 'locations' section.
 *
 * @package Fishers_Theme
 */

$locations = get_sub_field('locations');

?>

<section class="s-locations" id="locations">
    <div class="contain">
        <div class="row">
            <?php foreach ($locations as $location) { ?>
                <div class="col-12 col-md-6 col-xl-4 flow flow-space-300">
                    <iframe
                        class="s-locations__map"
                        width="800"
                        height="300"
                        style="border:0;"
                        allowfullscreen=""
                        loading="lazy"
                        src="https://maps.google.com/maps?q=<?= $location['lat']; ?>,<?= $location['lng']; ?>&hl=en&z=14&amp;output=embed"
                        >
                    </iframe>

                    <h2 class="ff-alt fw-medium"><?= $location['name']; ?></h2>
                    <address>
                        <?= $location['address']; ?>
                    </address>
                    <?php if ($location['phone']) { ?>
                        <a href="tel:<?= esc_attr($location['phone']); ?>" class="d-inline-block text-decoration-none text-pri,ary">
                            <span class="fas fa-phone-square" aria-hidden="true"></span>
                            <?= $location['phone']; ?>
                        </a>
                    <?php } ?>
                </div>
            <?php } ?>
        </div>
    </div>
</section>
