<?php
/**
 * Enquiry Section
 *
 * Flexible content section for 'enquiry' section.
 *
 * @package Fishers_Theme
 */

$title = get_sub_field('title');
$content = get_sub_field('content');
$form = get_sub_field('form');
$image = get_sub_field('image');

?>

<section class="s-enquiry bg-primary text-white" data-full>
    <div class="contain">
        <div class="s-enquiry__row row">
            <div class="s-enquiry__col col-12 col-lg-6">
                <div class="s-enquiry__header flow fw-bold measure-short">
                    <h2 class="text-white"><?= $title; ?></h2>
                    <?= $content; ?>
                </div>

                <?php if ($form) { ?>
                    <div class="s-enquiry__form mt-4">
                        <?= do_shortcode($form); ?>
                    </div>
                <?php } ?>
            </div>
        </div>
    </div>
    <?= Blue2\Scruffy\Utils::acf_img($image, [
        'class' => 's-enquiry__img'
    ]); ?>
</section>
