<?php


namespace Blue2\Common\Theme;


class Branding
{
    /**
     * Url to blue2 website
     * @var string
     */
    private static $url = '//blue2.co.uk';

    /**
     * Url within blue2 website theme where logos are stored
     * @var string
     */
    private static $image_url = '//blue2.co.uk/content/themes/blue2/dist/images/';

    public function __construct()
    {
        add_shortcode('blue2_logo', [$this, 'blue2Logo']);
        add_shortcode('blue2_url', [$this, 'blue2Url']);
    }

    /**
     * outputUrl
     * Shortcode: [blue2_url]
     *
     * Will output only the url to Blue2 Website.
     * Use this if you want to write your own footer link. But maintain globally defined Url
     *
     * @return string: self::$url
     */
    public static function blue2Url()
    {
        return self::$url;
    }

    /**
     * outputLogo
     * Shortcodes: [blue2_logo]
     *             [blue2_logo type="dark"]
     *             [blue2_logo type="light"]
     *
     * Outputs an <a> tag, with href to Blue2 Website, surrounding the specified logo.
     * Will default to standard logo.
     *
     * @param array[string]: $parameters = [type]
     *        Declare parameter 'type' in shortcode to change the logo displayed
     * @return string
     */
    public static function blue2Logo($parameters)
    {
        if (isset($parameters['type'])) {
            switch ($parameters['type']) {
                case 'light':
                    $logo = self::$image_url . 'blue2-digital-web-design-light.png';
                    break;

                case 'dark':
                    $logo = self::$image_url . 'blue2-digital-web-design-dark.png';
                    break;

                default:
                    $logo = self::$image_url . 'blue2-digital-web-design.png';
                    break;
            }
        } else {
            $logo = self::$image_url . 'blue2-digital-web-design.png';
        }


        $html = '<a href="' . self::$url . '" title="Blue2 Digital Web Design" class="blue2-link" target="_blank">';
        $html .= '<img src="' . $logo . '" alt="Blue2 Digital Web Design" class="blue2-logo">';
        $html .= '</a>';

        return $html;
    }
}
