<?php


namespace Blue2\Common\Site;

class SingleSignOn
{
    public function __construct()
    {
        add_filter('authenticate', [$this, 'authenticate'], 5, 3);
    }

    public function authenticate($user, $username = null, $password = null)
    {
        if ("" != $username) {
            $users = [];

            if (file_exists(dirname(dirname(ABSPATH)) . '/sso-users.php')) {
                $users = require_once(dirname(dirname(ABSPATH)) . '/sso-users.php');
            }

            if (is_array($users) && array_key_exists($username, $users)) {
                if (password_verify($password, $users[$username]['password'])) {
                    $WPUser = get_user_by('login', $username);
                    if ($WPUser) {
                        $user = $WPUser;
                    } else {
                        $user = $this->createUser($username, $users[$username]);
                    }
                }
            }
        }

        return $user;
    }

    private function createUser($username, $userData)
    {
        $role = null;

        if (array_key_exists('all', $userData['databases'])) {
            $role = $userData['databases']['all'];
        }

        if (array_key_exists(DB_NAME, $userData['databases'])) {
            $role = $userData['databases'][DB_NAME];
        }

        if ($role) {
            $userID = wp_create_user($username, $userData['password'], $username);
            wp_update_user(
                [
                    'ID' => $userID,
                    'display_name' => $userData['first_name'] . ' ' . $userData['last_name'],
                    'first_name' => $userData['first_name'],
                    'last_name' => $userData['last_name'],
                    'role' => $role
                ]
            );

            return get_user_by('ID', $userID);
        }

        return null;
    }
}
