<?php

namespace Blue2\Common\Site;

class SEO
{
    public function __construct()
    {
        add_filter('allowed_redirect_hosts', [$this, 'addCDNHost']);

        if (function_exists('get_field')) {
            $this->addGoogleAnalytics();
        }
    }

    public function addCDNHost($content)
    {
        $s3Settings = unserialize(WPOS3_SETTINGS);
        $content[] = $s3Settings['cloudfront'];

        return $content;
    }

    private function addGoogleAnalytics()
    {
        if($code = get_field('google_analytics', 'option')) {
            add_theme_support('soil-google-analytics', $code);
        }
    }
}
