<?php

namespace Blue2\Common\Site;

class PageBuilder
{
    private $defaultPages;

    public function __construct()
    {
        $this->defaultPages = [
            'style-guide' => [
                'post_title' => 'Style Guide',
            ],
            'privacy-policy' => [
                'post_title' => 'Privacy Policy',
                'post_content' => "<p>Privacy</p>",
            ],
        ];

        add_action('after_setup_theme', [$this, 'createPages']);
    }

    public function createPages()
    {
        foreach ($this->defaultPages as $slug => $pageArgs) {

            if (get_page_by_path($slug) == null) {
                // Add the page using the data from the array above
                $defaultArgs = [
                    'post_name' => $slug,
                    'post_status' => 'publish',
                    'post_type' => 'page',
                    'ping_status' => 'closed',
                    'comment_status' => 'closed',
                ];
                $args = array_merge($defaultArgs, $pageArgs);
                wp_insert_post($args);
            }
        }
    }
}
