<?php

namespace Blue2\Common;

class Site
{
    public function __construct()
    {
        new Site\PluginLoader();  // Load Required Plugins
        new Site\ACF();           // Set ACF Data folder, Auto-sync fields
        new Site\StandardMeta();  // Add Standard Meta to head
        new Site\PageBuilder();   // Add Standard Pages if required
        new Site\Robots();        // Add Standard Site crawl rules
        new Site\SEO();           // Allow Cloudfront CDN
        new Site\SingleSignOn();  // Run SSO on Authenticate

        add_action('after_setup_theme', [$this, 'addThemeSupport']);
        add_action('wp_enqueue_scripts', [$this, 'enqueueAssets'], 100);
        add_action('acf/init', [$this, 'acfInit']);
        add_action('init', [$this, 'removeEmojis']);

        new Theme\Branding();
    }

    public function addThemeSupport()
    {
        add_theme_support('title-tag');
        add_theme_support('post-thumbnails');
        add_theme_support('html5',
            [
                'caption',
                'comment-form',
                'comment-list',
                'gallery',
                'search-form'
            ]
        );

        // Soil theme support
        add_theme_support('soil-nav-walker');
        add_theme_support('soil-nice-search');
        add_theme_support('soil-relative-urls');
    }

    public function enqueueAssets()
    {
        wp_enqueue_style('b2/css', get_template_directory_uri() . '/dist/site.css', false, null);
        wp_enqueue_script('b2/js', get_template_directory_uri() . '/dist/site.js', ['jquery'], null, true);
    }

    public function removeEmojis()
    {
        remove_action('wp_head', 'print_emoji_detection_script', 7);
        remove_action('admin_print_scripts', 'print_emoji_detection_script');
        remove_action('wp_print_styles', 'print_emoji_styles');
        remove_action('admin_print_styles', 'print_emoji_styles');
        remove_filter('the_content_feed', 'wp_staticize_emoji');
        remove_filter('comment_text_rss', 'wp_staticize_emoji');
        remove_filter('wp_mail', 'wp_staticize_emoji_for_email');
    }

    public function acfInit()
    {
        acf_update_setting('google_api_key', 'AIzaSyDd2zxaqgRKOQayKtYzmgmxtxf9I5nIHL8');
    }


}
