<?php

function wp_new_user_notification($user_id, $deprecated = null, $notify = '')
{
    if ($deprecated !== null) {
        _deprecated_argument(__FUNCTION__, '4.3.1');
    }

    global $wpdb;
    global $wp_hasher;
    $user = get_userdata($user_id);

    // `$deprecated was pre-4.3 `$plaintext_pass`. An empty `$plaintext_pass` didn't sent a user notification.
    if ('admin' === $notify || (empty($deprecated) && empty($notify))) {
        return;
    }

    // Generate something random for a password reset key.
    $key = wp_generate_password(20, false);

    /** This action is documented in wp-login.php */
    do_action('retrieve_password_key', $user->user_login, $key);

    // Now insert the key, hashed, into the DB.
    if (empty($wp_hasher)) {
        require_once ABSPATH . WPINC . '/class-phpass.php';
        $wp_hasher = new PasswordHash(8, true);
    }
    $hashed = time() . ':' . $wp_hasher->HashPassword($key);
    $wpdb->update($wpdb->users, ['user_activation_key' => $hashed], ['user_login' => $user->user_login]);
}
