<?php
/**
 * Testimonials Section
 *
 * Flexible content section for 'testimonials' section.
 *
 * @package Fishers_Theme
 */

$testimonials = get_sub_field('testimonials');
$images = get_sub_field('images');

?>

<section class="s-testimonials text-center" data-full>
    <h2 class="visually-hidden">Testimonials</h2>
    <?php if($images){?>
    <div class="s-testimonials__images d-none d-md-flex">
        <?php foreach ($images as $image) { ?>
            <div
                class="s-testimonials__imageWrap"
                data-visible="">

                <?= Blue2\Scruffy\Utils::acf_img($image, [
                    'class' => 's-testimonials__image',
                    'size'  => 'standard-image'
                ]); ?>
            </div>
        <?php } ?>
    </div>
    <?php } ?>
    <div class="s-testimonials__content bg-primary text-white" style="background-image: url('<?= get_template_directory_uri(); ?>/dist/images/liver-bird-liverpool-on-primary.png');">
        <div
            class="s-testimonials__live visually-hidden"
            aria-live="polite"
            aria-atomic="true"
        >Item 1 of <?= count($testimonials); ?></div>
        <div
            id="testimonials"
            class="s-testimonials__list"
            role="region"
            aria-roledescription="carousel"
            aria-label="Testimonials">
            <?php foreach ($testimonials as $i => $testimonial) { ?>
                <blockquote
                    class="s-testimonials__single ff-alt fw-bold"
                    data-visible="<?= $i === 0 ? 'true' : 'false'; ?>"
                    role="group"
                    aria-roledescription="slide"
                    aria-label="<?= $i + 1; ?> of <?= count($testimonials); ?>"
                    tabindex="-1">

                    &ldquo;<?= $testimonial['quote']; ?>&rdquo;

                    <?php if ($testimonial['citation']) { ?>
                        <cite class="s-testimonials__citation d-block ff-main fw-normal fst-normal mt-4">
                            <?= $testimonial['citation']; ?>
                        </cite>
                    <?php } ?>
                </blockquote>
            <?php } ?>
        </div>
        <?php if (count($testimonials) > 1) { ?>
            <div class="s-testimonials__navWrap mt-3">
                <?php for ($i = 0; $i < count($testimonials); $i++) {
                    $is_first = $i === 0;
                    ?>
                    <button
                        class="s-testimonials__nav"
                        data-active="<?= $is_first ? 'true' : 'false'; ?>"
                        data-slide="<?= $i; ?>"
                        aria-controls="testimonials">
                        <span class="visually-hidden">
                            Slide <?= $i + 1; ?>
                        </span>
                        <span
                            style="<?= !$is_first ? 'display:none;' : null; ?>"
                            class="s-testimonials__current visually-hidden">
                            (current)
                        </span>
                    </button>
                <?php } ?>
            </div>
        <?php } ?>
    </div>
</section>
