<?php
/**
 * Media Section
 *
 * Flexible content section for 'media' section.
 *
 * @todo pagination buttons in article scroller
 * @todo dynamic articles and new categories
 *
 * @package Fishers_Theme
 */

$title = get_sub_field('title');
$link = get_sub_field('link');
$media = get_sub_field('media');

$posts = get_posts([
    'numberposts' => 6,
]);

?>

<section class="s-media bg-primary text-white overflow-hidden" data-full>
    <div class="s-media__topContain contain">
        <div class="s-media__head">
            <h2 class="fs-1 ff-alt lh-1 text-white fw-medium"><?= $title; ?></h2>
            <?php if ($link) { ?>
                <a class="d-inline-block fs-7 mt-4" href="<?= $link['url']; ?>"><?= $link['title']; ?></a>
            <?php } ?>
        </div>

        <?php if ($posts) { ?>
            <div class="s-media__articlesWrap">
                <ul class="s-media__articles" role="list">
                    <?php foreach ($posts as $post) { ?>
                        <li>
                            <article class="s-media__article">
                                <h3 class="s-media__articleTitle text-white fw-normal line-clamp">
                                    <a class="box-link" href="<?php the_permalink($post->ID); ?>">
                                        <?= get_the_title($post->ID); ?>
                                    </a>
                                </h3>
                                <?php
                                $feat_image = get_field('feat_image', $post->ID);
                                if ($feat_image) {
                                    echo Blue2\Scruffy\Utils::acf_img($feat_image, [
                                        'class' => 's-media__articleThumb',
                                        'size'  => 'thumbnail'
                                    ]);
                                } else {
                                    echo '<img class="s-media__articleThumb" src="' . get_template_directory_uri() . '/dist/images/news-placeholder.svg" width="872" height="461" alt="" loading="lazy">';
                                } ?>
                                <span class="s-media__articleView ff-alt fw-bold" aria-hidden="true">
                                    <a class="box-link" href="<?php the_permalink($post->ID); ?>">View Article</a>
                                    <span class="far fa-angle-right" aria-hidden="true"></span>
                                </span>
                            </article>
                        </li>
                    <?php } ?>
                </ul>
                <button class="s-media__articleNav" data-dir="prev">
                    <span class="far fa-angle-left" aria-hidden="true"></span>
                    <span class="visually-hidden">Previous Item</span>
                </button>
                <button class="s-media__articleNav" data-dir="next">
                    <span class="far fa-angle-right" aria-hidden="true"></span>
                    <span class="visually-hidden">Nect Item</span>
                </button>
            </div>
        <?php } ?>

    </div>

    <div class="contain">
        <?php if ($media) { ?>
            <div class="s-media__grid">
                <?php foreach ($media as $item) {
                    $layout = $item['acf_fc_layout'];
                    $layout = str_replace('_', '-', $layout);

                    unset($item['acf_fc_layout']);
                    $media_item_data = $item;

                    include __DIR__ . "/media/$layout.php";
                } ?>
            </div>
        <?php } ?>

    </div>
</section>
