<?php
/**
 * Call to Action Section
 *
 * Flexible content section for 'cta' section.
 *
 * @package Fishers_Theme
 */

$title = get_sub_field('title');
$subtitle = get_sub_field('subtitle');
$content = get_sub_field('content');
$buttons = get_sub_field('buttons');
$image = get_sub_field('image');
$rowIndex = get_row_index();
?>

<section class="s-cta bg-primary text-white text-center" data-full>
    <div class="contain contain-medium flow position-relative z-index-1">
        <?php if ($rowIndex==1){?>
            <h1 class="fs-1 text-inherit ff-alt"><?= $title; ?></h1>
        <?php }else{ ?>
            <h2 class="fs-1 text-inherit ff-alt"><?= $title; ?></h2>
        <?php } ?>
        <?php if ($subtitle) { ?>
            <p class="fs-5 fw-bold flow-space-700">
                <?= $subtitle; ?>
            </p>
        <?php } ?>

        <div class="measure-long flow mx-auto">
            <?= $content; ?>
        </div>

        <?php Blue2\Scruffy\Utils::Button_Row($buttons, [
            'wrap_class'    => 'mx-auto flow-space-700',
            'button_class'  => 'ff-alt'
        ]); ?>
    </div>
    <?= Blue2\Scruffy\Utils::acf_img($image, [
        'class' => 'multiply-bg'
    ]); ?>
</section>
