<?php
/**
 * Intro Content Section
 *
 * Flexible content section for 'intro_content' section.
 *
 * @package Fishers_Theme
 */

$custom_title = get_sub_field('title');
$subtitle = get_sub_field('subtitle');
$content = get_sub_field('content');
$image = get_sub_field('image');

$title = $custom_title ?: get_the_title();

?>

<section class="s-introContent">
    <div class="contain contain-medium">
        <div class="s-introContent__row">
            <div class="s-introContent__content flow">
                <h1 class="fs-0 ff-alt fw-medium text-primary-shade"><?= $title; ?></h1>

                <?php if ($subtitle) { ?>
                    <p class="fs-5 fw-bold"><?= $subtitle; ?></p>
                <?php } ?>

                <?= $content; ?>
            </div>

            <div class="s-introContent__imageWrap">
                <?= Blue2\Scruffy\Utils::acf_img($image, [
                    'class'     => 's-introContent__img',
                    'loading'   => 'eager',
                    'size'      => '16by9'
                ]); ?>
            </div>
        </div>
    </div>
</section>
