<?php
/**
 * Image Link Media Block
 *
 * Template for block 'image_link' of media section.
 *
 * @todo sort HTML ordering with title first
 *
 * @package Fishers_Theme
 */

$size = $media_item_data['size'];
$title = $media_item_data['title'];
$image = $media_item_data['image'];
$addVideo = $media_item_data['image_or_video'];
$video = $media_item_data['video'];
$link = $media_item_data['link'];

?>

<div class="s-media__item s-media__item--<?= $size; ?> s-media-imageLink">
    <?= Blue2\Scruffy\Utils::acf_img($image); ?>
    <?php 
      if($addVideo){
          ?>
          <video muted autoplay playsinline loop class="s-media-imageLink__video">
              <source src="<?= $video; ?>" type="video/mp4">
          </video>
          <?php
      }
    ?>
    <div class="s-media-imageLink__content d-flex align-items-end justify-content-between flex-wrap">
        <h3 class="s-media-imageLink__title text-white ff-alt fw-medium"><?= $title; ?></h3>
        <?php if ($link) { ?>
            <a class="s-media-imageLink__link ff-alt fw-bold box-link" href="<?= $link['url']; ?>">
                <?= $link['title']; ?>
                <span class="far fa-angle-right" aria-hidden="true"></span>
            </a>
        <?php } ?>
    </div>
</div>
