<?php
/**
 * Post Sidebar
 *
 * @package Fishers_Theme
 */

?>
<aside class="p-sidebar flow">
    <?php if (has_nav_menu('categories')) { ?>
        <nav aria-labelledby="archive-cats-title" class="p-sidebar__cats bg-primary text-white">
            <h2 id="archive-cats-title" class="text-inherit mb-4 ff-alt fw-medium">Explore our news categories:</h2>

            <?php wp_nav_menu([
                'theme_location'    => 'categories',
                'menu_container'    => 'ul',
                'menu_class'        => 'p-sidebar__catList fw-bold flow',
                'items_wrap'        => '<ul id="%1$s" class="%2$s" role="list">%3$s</ul>',
            ]); ?>
        </nav>
    <?php } ?>

    <?php if (has_nav_menu('services')) { ?>
        <div class="p-sidebar__services text-primary-shade">
            <h2 class="mb-4 ff-alt fw-medium fs-6 text-inherit">Dependable service</h2>

            <?php wp_nav_menu([
                'theme_location'    => 'services',
                'menu_container'    => 'ul',
                'menu_class'        => 'p-sidebar__servicesList ff-alt fw-bold flow',
                'items_wrap'        => '<ul id="%1$s" class="%2$s" role="list">%3$s</ul>',
            ]); ?>
        </div>
    <?php } ?>

    <div class="p-sidebar__feature b-feature b-feature--landscape text-white">
        <div class="b-feature__inner flex-column">
            <h3 class="b-feature__title text-inherit ff-alt">Dependable Partners.</h3>

            <span class="b-feature__subtitle">
                We offer a range of nationwide services in Hospitality, Workwear, Healthcare & Cleanroom.
            </span>

            <a class="b-feature__link ff-alt fw-bold box-link" href="<?= $link['url']; ?>">
                Start your service with us today
                <span class="b-feature__icon far fa-angle-right" aria-hidden="true"></span>
            </a>
        </div>

        <img src="<?= get_template_directory_uri(); ?>/dist/images/illustration-feature.svg" alt="Illustration of Edinburgh Castle, bridge, and the Angel of the North" class="b-feature__image" width="1300" height="520" loading="lazy">
    </div>
</aside>
