<?php
/**
 * Feature Media Block
 *
 * Template for block 'feature' of media section.
 *
 * @todo sort HTML ordering with title first
 *
 * @package Fishers_Theme
 */

$title = $media_item_data['title'];
$subtitle = $media_item_data['subtitle'];
$link = $media_item_data['link'];
$image = $media_item_data['image'];
$bg_image = $media_item_data['bg_image'];

?>

<div class="s-media__item s-media__item--feature b-feature">
    <div class="b-feature__inner">
        <span class="b-feature__subtitle"><?= $subtitle; ?></span>
        <?php 
        if($title){
        ?>
            <h3 class="b-feature__title text-white"><?= $title; ?></h3>
        <?php
            }
        ?>    
        <?php if ($link) { ?>
            <a class="b-feature__link ff-alt fw-bold box-link" href="<?= $link['url']; ?>">
                <?= $link['title']; ?>
                <span class="far fa-angle-right" aria-hidden="true"></span>
            </a>
        <?php } ?>
    </div>
    <?= Blue2\Scruffy\Utils::acf_img($image, [
        'class'     => 'b-feature__image'
    ]); ?>
    <?= Blue2\Scruffy\Utils::acf_img($bg_image, [
        'class'     => 'b-feature__bg'
    ]); ?>
</div>
