import ModalVideo from 'modal-video';
import 'modal-video/css/modal-video.min.css';
// media article list dynamic properties
const mediaProps = () => {
    const threshold = 300;

    const wrap = document.querySelector('.s-media__articlesWrap');
    if (!wrap) {
        return;
    }

    const scroller = wrap.querySelector('.s-media__articles');

    if (!scroller) {
        return;
    }

    scroller.addEventListener('scroll', () => {
        const posLeft = scroller.scrollLeft;
        const shadowLeft = Math.min((posLeft / threshold), 1);
        wrap.style.setProperty('--shadow-left', shadowLeft);
        wrap.style.setProperty(
            '--show-prev',
            posLeft > 0 ? 'block' : 'none'
        );

        const posRight = scroller.scrollWidth - scroller.offsetWidth - posLeft;
        const shadowRight = Math.min((posRight / threshold), 1);
        wrap.style.setProperty('--shadow-right', shadowRight);
        wrap.style.setProperty(
            '--show-next',
            posRight > 0 ? 'block' : 'none'
        );
    });
};
const mediaVideo = () => {
    new ModalVideo('.modal-link');
    // const modal = document.querySelectorAll('.modal-link');

    // modal.forEach(el => {
    //     el.addEventListener('click', () => {
    //         new ModalVideo(el);
    //     });
    // });
};

// media article nav
const mediaNav = () => {
    const nav = document.querySelectorAll('.s-media__articleNav');

    nav.forEach(el => {
        el.addEventListener('click', () => {
            const wrap = el.closest('.s-media__articlesWrap');
            const list = wrap.querySelector('.s-media__articles');
            const item = wrap.querySelector('.s-media__articles > li');
            const itemWidth = item.offsetWidth;

            const dir = el.getAttribute('data-dir');
            let scrollAmount = itemWidth;
            if (dir === 'prev') {
                scrollAmount = 0 - scrollAmount;
            }

            list.scrollBy(scrollAmount, 0);
        });
    });
};

export default () => {
    mediaVideo();
    mediaNav();
    mediaProps();
};
