<?php
/**
 * Titlebar Section
 *
 * Flexible content section for 'titlebar' section.
 *
 * @package Fishers_Theme
 */

$title = get_sub_field('title');
$content = get_sub_field('content');
$image = get_sub_field('image');

?>

<section class="s-titlebar bg-primary text-white text-center" data-full>
    <div class="s-titlebar__contain contain flow">
        <h1 class="fs-0 text-white ff-alt fw-medium"><?= $title; ?></h1>

        <?php if ($content) { ?>
            <div class="s-titlebar__description measure-medium mx-auto fs-4">
                <?= $content; ?>
            </div>
        <?php } ?>
    </div>
    <?= Blue2\Scruffy\Utils::acf_img($image, [
        'class'     => 'multiply-bg',
        'loading'   => 'eager'
    ]); ?>
</section>
