<?php
/**
 * Service - Video Section
 *
 * Flexible content section for 'service_video' section.
 *
 * @package Fishers_Theme
 */

$style = get_sub_field('style');
$banner_style = $style === 'banner';

$header_title = get_sub_field('header_title');
$header_subtitle = get_sub_field('header_subtitle');
$title = get_sub_field('title');
$content = get_sub_field('content');
$buttons = get_sub_field('buttons');
$video_1 = get_sub_field('video_1');
$video_2 = get_sub_field('video_2');
$mobile_image = get_sub_field('mobile_image');
$bg_image = get_sub_field('bg_image');

if($style == 'normal'){
    $aos_settings = 'data-aos="fade-right"';
}else{
    $aos_settings = 'data-aos="fade-left"';
}

?>

<section
    class="s-serviceVideo s-serviceVideo--<?= $style; ?><?= $banner_style ? ' bg-primary text-white' : null; ?>"
    <?= $banner_style ? 'data-full' : null; ?>>

    <?php if ($banner_style && $bg_image) { ?>
        <?= Blue2\Scruffy\Utils::acf_img($bg_image, [
            'class' => 's-serviceVideo__bg'
        ]); ?>
    <?php } ?>

    <div class="s-serviceVideo__contain contain">
        <div class="s-serviceVideo__content">
            <?php if ($header_title || $header_subtitle) { ?>
                <div class="s-serviceVideo__head fw-bold">
                    <?php if ($header_title) { ?>
                        <div class="s-serviceVideo__title ff-alt lh-1 mb-2<?= $banner_style ? ' text-white' : null; ?>"><?= $header_title; ?></div>
                    <?php }
                    echo $header_subtitle;
                    ?>
                </div>
            <?php } ?>
            <?php if ($mobile_image) { ?>
                <div class="s-serviceVideo__image d-md-none">
                    <?= Blue2\Scruffy\Utils::acf_img($mobile_image); ?>
                </div>
            <?php } ?>
            <div class="s-serviceVideo__body flow">
                <div class="measure-short flow">
                    <h2 class="<?= $banner_style ? 'text-white' : null; ?>"><?= $title; ?></h2>
                    <?= $content; ?>
                </div>

                <?php Blue2\Scruffy\Utils::Button_Row($buttons, [
                    'wrap_class' => 'flow-space-700'
                ]); ?>
            </div>
        </div>

        <div class="s-serviceVideo__videos">
            <?php if ($video_1) { 
                  // is it a video or an image?
                  if ( str_ends_with($video_1,'.jpg') || str_ends_with($video_1,'.png') || str_ends_with($video_1,'.gif') ){
                ?>
                    <div class="s-serviceVideo__video s-serviceVideo__video--narrow" <?= $aos_settings ?>>
                        <img class="img-fluid" src="<?= $video_1; ?>" alt=""/>
                    </div>
                <?php
                  } else { 
                ?>
                    <video class="s-serviceVideo__video s-serviceVideo__video--narrow" autoplay loop muted playsinline <?= $aos_settings ?>>
                        <source src="<?= $video_1; ?>" type="video/mp4">
                    </video>
                <?php }
                    } ?>
                <?php if ($video_2) { 
                    // is it a video or an image?
                    if ( str_ends_with($video_2,'.jpg') || str_ends_with($video_2,'.png') || str_ends_with($video_2,'.gif') ){
                   ?>
                    <div class="s-serviceVideo__video s-serviceVideo__video--narrow" <?= $aos_settings ?> data-aos-offset="150">
                        <img class="img-fluid" src="<?= $video_1; ?>" alt=""/>
                    </div>
                    <?php
                    } else { 
                    ?>
                    <video class="s-serviceVideo__video s-serviceVideo__video--wide" autoplay loop muted playsinline <?= $aos_settings ?> data-aos-offset="150">
                        <source src="<?= $video_2; ?>" type="video/mp4">
                    </video>
                <?php } 
                }
            ?>
        </div>

    </div>
</section>
