<?php
namespace Blue2\Scruffy;

use Blue2\Scruffy\Controllers\OEmbedController;

class Site extends \Blue2\Common\Site
{
    public function __construct()
    {
        parent::__construct();

        add_action('after_setup_theme', [$this, 'registerMenus']);
        add_action('after_setup_theme', [$this, 'addImageSizes']);

        $this->registerShortCodes();
        $this->registerFilters();
        $this->registerActions();
        $this->setupControllers();
    }

    public function registerMenus()
    {
        register_nav_menus([
            'primary'       => 'Main Menu',
            'secondary'     => 'Footer Menu',
            'tertiary'      => 'Footer Menu 2',
            'services'      => 'Services',
            'categories'    => 'Categories'
        ]);
    }

    /**
     * addImageSizes
     *
     * register custom image sizes
     */
    public function addImageSizes()
    {
        add_image_size('full', 1920, 1080, false);
        add_image_size('banner', 1920, 610, false);
        add_image_size('16by9', 800, 450, ['center','center']);
        add_image_size('wide-image', 910, 370, ['center','center']);
        add_image_size('standard-image', 500, 425, ['center','center']);
    }

    private function registerShortCodes()
    {
        // Empty
    }

    private function registerFilters()
    {
        add_filter('acf/load_field/name=button_style', [$this, 'acf_button_styles']);
        add_filter('acf/load_field/name=button_icon', [$this, 'acf_button_icons']);

        // contact form 7
        add_filter('wpcf7_autop_or_not', '__return_false');
        add_filter('wpcf7_load_css', '__return_false');
    }

    private function registerActions() {
        add_action('init', [$this, 'registerPostTypes']);
    }

    private function setupControllers() {
        new OEmbedController();
    }

    public function registerPostTypes()
    {
    }

    /**
     * acf_button_styles
     *
     * populate select field with name 'button_style' with all button style options
     *
     * @param  array $field
     * @return array
     */
    public function acf_button_styles($field)
    {
        // change choices
        $field['choices'] = [
            'default'           => 'Default',
            'border'            => 'Border',
            'inverse'           => 'Inverse',
            'border-inverse'    => 'Border Inverse',
            'border-white'      => 'Border White'
        ];

        // if default_value is not set, set it to 'default'
        if (!$field['default_value']) {
            $field['default_value'] = 'default';
        }

        // return the field
        return $field;
    }

    /**
     * acf_button_icons
     *
     * populate select field with name 'button_icon' with all button icon options
     *
     * @param  array $field
     * @return array
     */
    public function acf_button_icons($field)
    {
        // change choices
        $field['choices'] = [
            ''                      => 'None',
            'far fa-angle-left'     => 'Angle Left',
            'far fa-angle-right'    => 'Angle Right',
            'far fa-check'          => 'Check',
            'fas fa-folder-open'    => 'Folder Open',
            'fas fa-lock'           => 'Lock',
            'fas fa-microscope'     => 'Microscope',
            'fas fa-plus'           => 'Plus',
            'fas fa-street-view'    => 'Street View',
            'fas fa-utensils'       => 'Utensils',
            'fas fa-vial'           => 'Vial',
            'fab fa-linkedin-in'    => 'LinkedIn',
            'fab fa-twitter'        => 'Twitter'
        ];

        // if default_value is not set, set it to ''
        if (!$field['default_value']) {
            $field['default_value'] = '';
        }

        // return the field
        return $field;
    }
}
