<?php
/**
 * Categories Media Block
 *
 * Template for block 'categories' of media section.
 *
 * @todo categories should be dynamic
 *
 * @package Fishers_Theme
 */

$title = $media_item_data['title'];

?>

<div class="d-none d-md-block s-media__item s-media__item--cats s-media-cats">
    <?php 
        if($title){
        ?>
    <h3 id="media-category-title" class="s-media-cats__title ff-alt fw-medium text-white"><?= $title; ?></h3>
    <?php
        }
    ?>
    <nav aria-labelledby="media-category-title" class="b-categories">
        <?php if (has_nav_menu('categories')) { ?>
            <?php wp_nav_menu([
                'theme_location'    => 'categories',
                'menu_container'    => 'ul',
                'menu_class'        => 'b-categories__list text-center',
                'items_wrap'        => '<ul id="%1$s" class="%2$s" role="list">%3$s</ul>',
            ]); ?>
        <?php } ?>
    </nav>
</div>
