<?php
/**
 * Captioned Image Section
 *
 * Flexible content section for 'captioned_image' section.
 *
 * @package Fishers_Theme
 */

$direction = get_sub_field('direction');
$content = get_sub_field('content');
$image = get_sub_field('image');

?>

<section class="s-captionedImage s-captionedImage--<?= $direction; ?>" data-full>
    <div class="contain">
        <div class="s-captionedImage__row row">
            <div class="col-12 col-lg-6">
                <div class="s-captionedImage__content flex-column pt-4 pb-5 flow">
                    <?= $content; ?>
                </div>
            </div>
        </div>
    </div>
    <?= Blue2\Scruffy\Utils::acf_img($image, [
        'class' => 's-captionedImage__img'
    ]); ?>
</section>
